/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class DmDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 3415348435502927423L;

    public DmDialect(DbConfig dbConfig) {
        super(dbConfig);
    }

    @Override
    public String dialectName() {
        return DialectName.DM.name();
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) {
        Assert.notEmpty(keys, "Keys must be not empty for DM MERGE SQL.", new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.of(this.quoteWrapper);
        List<String> keyList = Arrays.asList(keys);
        StringBuilder keyFieldsPart = new StringBuilder();
        StringBuilder updateFieldsPart = new StringBuilder();
        StringBuilder insertFieldsPart = new StringBuilder();
        StringBuilder insertPlaceHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field) && keyList.contains(field)) {
                if (keyFieldsPart.length() > 0) {
                    keyFieldsPart.append(" and ");
                }
                keyFieldsPart.append((String)field).append("= ?");
                builder.addParams(value);
            }
        });
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field) && !keyList.contains(field)) {
                if (updateFieldsPart.length() > 0) {
                    updateFieldsPart.append(", ");
                }
                updateFieldsPart.append((String)field).append("= ?");
                builder.addParams(value);
            }
        });
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field)) {
                if (insertFieldsPart.length() > 0) {
                    insertFieldsPart.append(", ");
                    insertPlaceHolder.append(", ");
                }
                insertFieldsPart.append(null != this.quoteWrapper ? this.quoteWrapper.wrap((String)field) : field);
                insertPlaceHolder.append("?");
                builder.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
        }
        builder.append("MERGE INTO ").append(tableName).append(" USING DUAL ON ").append(keyFieldsPart).append(" WHEN MATCHED THEN UPDATE SET ").append(updateFieldsPart).append(" WHEN NOT MATCHED THEN INSERT (").append(insertFieldsPart).append(") VALUES (").append(insertPlaceHolder).append(")");
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, builder.build(), builder.getParamValueArray());
    }
}

