/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.PageResult;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.RsHandler;

public class PageResultHandler<T>
implements RsHandler<PageResult<T>> {
    private static final long serialVersionUID = 1L;
    private final Class<T> beanClass;
    private final PageResult<T> pageResult;
    private boolean caseInsensitive;

    public static PageResultHandler<Entity> of(PageResult<Entity> pageResult) {
        return PageResultHandler.of(Entity.class, pageResult);
    }

    public static <T> PageResultHandler<T> of(Class<T> beanClass, PageResult<T> pageResult) {
        return new PageResultHandler<T>(beanClass, pageResult);
    }

    public PageResultHandler(Class<T> beanClass, PageResult<T> pageResult) {
        this.beanClass = beanClass;
        this.pageResult = pageResult;
    }

    public PageResultHandler<T> setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    @Override
    public PageResult<T> handle(ResultSet rs) throws SQLException {
        if (Entity.class == this.beanClass) {
            return ResultSetUtil.toEntityList(rs, this.pageResult, this.caseInsensitive);
        }
        return ResultSetUtil.toBeanList(rs, this.pageResult, this.beanClass);
    }
}

