/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.meta;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.db.meta.Column;
import org.dromara.hutool.db.meta.IndexInfo;

public class Table
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -810699625961392983L;
    private String schema;
    private String catalog;
    private String tableName;
    private String pureTableName;
    private String remarks;
    private Set<String> pkNames = new LinkedHashSet<String>();
    private List<IndexInfo> indexInfoList;
    private final Map<String, Column> columns = new LinkedHashMap<String, Column>();

    public static Table of(String tableName) {
        return new Table(tableName);
    }

    public Table(String tableName) {
        this.setTableName(tableName);
    }

    public String getSchema() {
        return this.schema;
    }

    public Table setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Table setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPureTableName() {
        return this.pureTableName;
    }

    public void setPureTableName(String pureTableName) {
        this.pureTableName = pureTableName;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Table setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    public Set<String> getPkNames() {
        return this.pkNames;
    }

    public boolean isPk(String columnName) {
        return this.getPkNames().contains(columnName);
    }

    public void setPkNames(Set<String> pkNames) {
        this.pkNames = pkNames;
    }

    public Table addColumn(Column column) {
        this.columns.put(column.getName(), column);
        return this;
    }

    public Column getColumn(String name) {
        return this.columns.get(name);
    }

    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public Table addPk(String pkColumnName) {
        this.pkNames.add(pkColumnName);
        return this;
    }

    public List<IndexInfo> getIndexInfoList() {
        return this.indexInfoList;
    }

    public void setIndexInfoList(List<IndexInfo> indexInfoList) {
        this.indexInfoList = indexInfoList;
    }

    public Table clone() throws CloneNotSupportedException {
        return (Table)super.clone();
    }
}

