/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.pinyin.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.pinyin.PinyinException;
import org.dromara.hutool.extra.pinyin.engine.PinyinEngine;
import org.dromara.hutool.log.LogUtil;

public class PinyinEngineFactory {
    public static PinyinEngine getEngine() {
        PinyinEngine engine = Singleton.get(PinyinEngine.class.getName(), PinyinEngineFactory::createEngine);
        LogUtil.debug("Use [{}] Pinyin Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    public static PinyinEngine createEngine() {
        return PinyinEngineFactory.doCreateEngine();
    }

    public static PinyinEngine createEngine(String engineName) throws PinyinException {
        if (!StrUtil.endWithIgnoreCase(engineName, "Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader<PinyinEngine> list = SpiUtil.loadList(PinyinEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase(serviceName, engineName)) continue;
            return list.getService(serviceName);
        }
        throw new PinyinException("No such engine named: " + engineName);
    }

    private static PinyinEngine doCreateEngine() {
        PinyinEngine engine = SpiUtil.loadFirstAvailable(PinyinEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new PinyinException("No pinyin jar found !Please add one of it to your project !");
    }
}

