/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.StreamProgress;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.engine.ClientEngineFactory;

public class HttpDownloader {
    public static String downloadString(String url, Charset customCharset, StreamProgress streamPress) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        HttpDownloader.download(url, out, true, streamPress);
        return null == customCharset ? out.toString() : out.toString(customCharset);
    }

    public static byte[] downloadBytes(String url) {
        return HttpDownloader.downloadBytes(url, 0);
    }

    public static byte[] downloadBytes(String url, int timeout) {
        return HttpDownloader.requestDownload(url, timeout).bodyBytes();
    }

    public static File downloadFile(String url, File targetFileOrDir) {
        return HttpDownloader.downloadFile(url, targetFileOrDir, -1);
    }

    public static File downloadFile(String url, File targetFileOrDir, int timeout) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] is null !", new Object[0]);
        return HttpDownloader.downloadFile(url, targetFileOrDir, timeout, null);
    }

    public static File downloadFile(String url, File targetFileOrDir, int timeout, StreamProgress streamProgress) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] is null !", new Object[0]);
        return HttpDownloader.requestDownload(url, timeout).body().write(targetFileOrDir, streamProgress);
    }

    public static File downloadFile(String url, File targetFileOrDir, String tempFileSuffix, int timeout, StreamProgress streamProgress) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] is null !", new Object[0]);
        return HttpDownloader.requestDownload(url, timeout).body().write(targetFileOrDir, tempFileSuffix, streamProgress);
    }

    public static long download(String url, OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        Assert.notNull(out, "[out] is null !", new Object[0]);
        return HttpDownloader.requestDownload(url, -1).body().write(out, isCloseOut, streamProgress);
    }

    private static Response requestDownload(String url, int timeout) {
        Response response;
        Assert.notBlank(url, "[url] is blank !", new Object[0]);
        ClientConfig config = ClientConfig.of();
        if (timeout > 0) {
            config.setTimeout(timeout);
        }
        if ((response = ClientEngineFactory.getEngine().init(config).send(Request.of(url))).isOk()) {
            return response;
        }
        throw new HttpException("Server response error with status code: [{}]", response.getStatus());
    }
}

