/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.BytesResource;
import org.dromara.hutool.core.io.resource.FileResource;
import org.dromara.hutool.core.io.resource.HttpResource;
import org.dromara.hutool.core.io.resource.InputStreamResource;
import org.dromara.hutool.core.io.resource.MultiResource;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.StringResource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.meta.ContentType;

public class MultipartOutputStream
extends OutputStream {
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n";
    private final OutputStream out;
    private final Charset charset;
    private final String boundary;
    private boolean isFinish;

    public MultipartOutputStream(OutputStream out, Charset charset) {
        this(out, charset, HttpGlobalConfig.getBoundary());
    }

    public MultipartOutputStream(OutputStream out, Charset charset, String boundary) {
        this.out = out;
        this.charset = charset;
        this.boundary = boundary;
    }

    public MultipartOutputStream write(String formFieldName, Object value) throws IORuntimeException {
        if (value instanceof MultiResource) {
            for (Resource subResource : (MultiResource)value) {
                this.write(formFieldName, subResource);
            }
            return this;
        }
        this.beginPart();
        if (value instanceof Resource) {
            this.appendResource(formFieldName, (Resource)value);
        } else if (value instanceof File) {
            this.appendResource(formFieldName, new FileResource((File)value));
        } else if (value instanceof Path) {
            this.appendResource(formFieldName, new FileResource((Path)value));
        } else if (value instanceof byte[]) {
            this.appendResource(formFieldName, new BytesResource((byte[])value));
        } else if (value instanceof InputStream) {
            this.appendResource(formFieldName, new InputStreamResource((InputStream)value));
        } else if (value instanceof Reader) {
            this.appendResource(formFieldName, new InputStreamResource((Reader)value, this.charset));
        } else {
            this.appendResource(formFieldName, new StringResource(ConvertUtil.toStr(value), null, this.charset));
        }
        this.write("\r\n");
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void finish() throws IORuntimeException {
        if (!this.isFinish) {
            this.write(StrUtil.format("--{}--\r\n", this.boundary));
            this.isFinish = true;
        }
    }

    @Override
    public void close() {
        this.finish();
        IoUtil.closeQuietly(this.out);
    }

    private void appendResource(String formFieldName, Resource resource) throws IORuntimeException {
        String fileName = resource.getName();
        if (null == fileName) {
            this.write(StrUtil.format(CONTENT_DISPOSITION_TEMPLATE, formFieldName));
        } else {
            this.write(StrUtil.format(CONTENT_DISPOSITION_FILE_TEMPLATE, formFieldName, fileName));
        }
        if (resource instanceof HttpResource) {
            String contentType = ((HttpResource)resource).getContentType();
            if (StrUtil.isNotBlank(contentType)) {
                this.write(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, contentType));
            }
        } else if (StrUtil.isNotEmpty(fileName)) {
            this.write(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, FileUtil.getMimeType(fileName, ContentType.OCTET_STREAM.getValue())));
        }
        this.write("\r\n");
        resource.writeTo(this);
    }

    private void beginPart() {
        this.write("--", this.boundary, "\r\n");
    }

    private void write(CharSequence ... contents) {
        IoUtil.writeStrs(this, this.charset, false, contents);
    }
}

