/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.engine.AbstractClientEngine;
import org.dromara.hutool.http.client.engine.jdk.JdkCookieManager;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpResponse;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.HttpStatus;
import org.dromara.hutool.http.meta.Method;

public class JdkClientEngine
extends AbstractClientEngine {
    private JdkCookieManager cookieManager;

    public JdkCookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public JdkHttpResponse send(Request message) {
        JdkHttpConnection conn = this.buildConn(message);
        try {
            this.doSend(conn, message);
        }
        catch (IOException e) {
            IoUtil.closeQuietly(conn);
            throw new IORuntimeException(e);
        }
        return this.sendRedirectIfPossible(conn, message);
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
        this.cookieManager = null;
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void initEngine() {
        this.cookieManager = null != this.config && this.config.isUseCookieManager() ? new JdkCookieManager() : new JdkCookieManager(null);
    }

    private void doSend(JdkHttpConnection conn, Request message) throws IOException {
        HttpBody body = message.handledBody();
        if (null != body) {
            body.writeClose(conn.getOutputStream());
            return;
        }
        conn.connect();
    }

    private JdkHttpConnection buildConn(Request message) {
        ClientConfig config = ObjUtil.defaultIfNull(this.config, ClientConfig::of);
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(message.handledUrl().toURL(), (Proxy)config.getProxy()).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSSLInfo(config.getSslInfo()).setInstanceFollowRedirects(config.isFollowRedirects()).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (!message.method().isIgnoreBody()) {
            long contentLength = message.contentLength();
            if (contentLength > 0L) {
                conn.setFixedLengthStreamingMode(contentLength);
            } else if (message.isChunked()) {
                conn.setChunkedStreamingMode(4096);
            }
        }
        if (null == message.header(HeaderName.COOKIE) && null != this.cookieManager) {
            conn.header(this.cookieManager.loadForRequest(conn), false);
        }
        return conn;
    }

    private JdkHttpResponse sendRedirectIfPossible(JdkHttpConnection conn, Request message) {
        if (message.maxRedirects() > 0) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.closeQuietly();
                throw new HttpException(e);
            }
            if (code != 200 && HttpStatus.isRedirected(code)) {
                message.url(JdkClientEngine.getLocationUrl(message.handledUrl(), conn.header(HeaderName.LOCATION)));
                if (307 != code) {
                    message.method(Method.GET);
                }
                if (conn.redirectCount < message.maxRedirects()) {
                    ++conn.redirectCount;
                    return this.send(message);
                }
            }
        }
        return new JdkHttpResponse(conn, this.cookieManager, message);
    }

    private static UrlBuilder getLocationUrl(UrlBuilder parentUrl, String location) {
        UrlBuilder redirectUrl;
        if (!HttpUtil.isHttp(location) && !HttpUtil.isHttps(location)) {
            String query;
            List<String> split;
            if (!location.startsWith("/")) {
                location = StrUtil.addSuffixIfNot(parentUrl.getPathStr(), "/") + location;
            }
            if ((split = SplitUtil.split(location, "?", 2, true, true)).size() == 2) {
                location = split.get(0);
                query = split.get(1);
            } else {
                query = null;
            }
            redirectUrl = UrlBuilder.of(parentUrl.getScheme(), parentUrl.getHost(), parentUrl.getPort(), location, query, null, parentUrl.getCharset());
        } else {
            redirectUrl = UrlBuilder.ofHttpWithoutEncode(location);
        }
        return redirectUrl;
    }
}

