/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.webservice;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.xml.XmlUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.webservice.SoapRuntimeException;

public class SoapResponse {
    private final Response response;
    private final MessageFactory factory;
    private SOAPMessage message;
    private SOAPBody body;

    public SoapResponse(Response response, MessageFactory factory) {
        this.response = response;
        this.factory = factory;
    }

    public Response getHttpResponse() {
        return this.response;
    }

    public String getResponseStr(boolean pretty) {
        String messageStr = this.response.bodyStr();
        return pretty ? XmlUtil.format(messageStr) : messageStr;
    }

    public SOAPMessage getMessage() {
        if (null == this.message) {
            MimeHeaders headers = new MimeHeaders();
            for (Map.Entry<String, List<String>> entry : this.response.headers().entrySet()) {
                if (!StrUtil.isNotEmpty(entry.getKey())) continue;
                headers.setHeader(entry.getKey(), (String)CollUtil.get((Collection)entry.getValue(), 0));
            }
            try {
                this.message = this.factory.createMessage(headers, this.response.bodyStream());
            }
            catch (SOAPException | IOException e) {
                try {
                    throw new SoapRuntimeException(e);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly(this.response);
                    throw throwable;
                }
            }
            IoUtil.closeQuietly(this.response);
        }
        return this.message;
    }

    public SOAPBody getBody() {
        if (null == this.body) {
            try {
                this.body = this.getMessage().getSOAPBody();
            }
            catch (SOAPException e) {
                throw new SoapRuntimeException(e);
            }
        }
        return this.body;
    }

    public String getBodyText() {
        return this.getBody().getTextContent();
    }

    public boolean hasFault() {
        return this.getBody().hasFault();
    }

    public SOAPFault getFault() {
        return this.getBody().getFault();
    }
}

