/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.fastjson;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class FastJSON2Engine
extends AbstractJSONEngine {
    private JSONReader.Context readerContext;
    private JSONWriter.Context writerContext;

    public FastJSON2Engine() {
        Assert.notNull(JSONFactory.class);
    }

    @Override
    public void serialize(Object bean, OutputStream out) {
        JSONWriter jsonWriter = null;
        try {
            jsonWriter = this.toJsonWriter(bean);
            jsonWriter.flushTo(out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(new AutoCloseable[]{jsonWriter});
                throw throwable;
            }
        }
        IoUtil.closeQuietly(new AutoCloseable[]{jsonWriter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonString(Object bean) {
        String string;
        JSONWriter jsonWriter = null;
        try {
            jsonWriter = this.toJsonWriter(bean);
            string = jsonWriter.toString();
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(new AutoCloseable[]{jsonWriter});
            throw throwable;
        }
        IoUtil.closeQuietly(new AutoCloseable[]{jsonWriter});
        return string;
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        ObjectReader objectReader = this.readerContext.getObjectReader((Type)type);
        try (JSONReader jsonReader = JSONReader.of((Reader)reader, (JSONReader.Context)this.readerContext);){
            if (jsonReader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(jsonReader, (Type)type, null, 0L);
            jsonReader.handleResolveTasks(object);
            Object object2 = object;
            return (T)object2;
        }
    }

    @Override
    protected void reset() {
        this.readerContext = null;
        this.writerContext = null;
    }

    @Override
    protected void initEngine() {
        JSONEngineConfig config;
        if (null == this.readerContext) {
            this.readerContext = JSONFactory.createReadContext();
            config = ObjUtil.defaultIfNull(this.config, JSONEngineConfig::of);
            this.readerContext.setDateFormat(ObjUtil.defaultIfNull(config.getDateFormat(), "millis"));
        }
        if (null == this.writerContext) {
            ArrayList<JSONWriter.Feature> features = ListUtil.of(new JSONWriter.Feature[0]);
            config = ObjUtil.defaultIfNull(this.config, JSONEngineConfig::of);
            if (config.isPrettyPrint()) {
                features.add(JSONWriter.Feature.PrettyFormat);
            }
            if (!config.isIgnoreNullValue()) {
                features.add(JSONWriter.Feature.WriteMapNullValue);
            }
            this.writerContext = JSONFactory.createWriteContext((JSONWriter.Feature[])features.toArray(new JSONWriter.Feature[0]));
            this.writerContext.setDateFormat(ObjUtil.defaultIfNull(config.getDateFormat(), "millis"));
        }
    }

    private JSONWriter toJsonWriter(Object bean) {
        this.initEngine();
        JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Context)this.writerContext);
        if (bean == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.setRootObject(bean);
            Class<?> valueClass = bean.getClass();
            ObjectWriter objectWriter = this.writerContext.getObjectWriter(valueClass, valueClass);
            objectWriter.write(jsonWriter, bean, null, null, 0L);
        }
        return jsonWriter;
    }
}

