/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.wrapper.Wrapper;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;
import org.dromara.hutool.json.engine.jackson.TemporalModule;

public class JacksonEngine
extends AbstractJSONEngine
implements Wrapper<ObjectMapper> {
    private ObjectMapper mapper;

    public JacksonEngine() {
        Assert.notNull(ObjectMapper.class);
    }

    @Override
    public ObjectMapper getRaw() {
        this.initEngine();
        return this.mapper;
    }

    @Override
    public void serialize(Object bean, OutputStream out) {
        this.initEngine();
        try {
            this.mapper.writeValue(out, bean);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public String toJsonString(Object bean) {
        this.initEngine();
        try {
            return this.mapper.writeValueAsString(bean);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        try {
            if (type instanceof Class) {
                return (T)this.mapper.readValue(reader, (Class)type);
            }
            if (type instanceof TypeReference) {
                return (T)this.mapper.readValue(reader, (TypeReference)type);
            }
            if (type instanceof JavaType) {
                return (T)this.mapper.readValue(reader, (JavaType)type);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        throw new JSONException("Unsupported type: {}", type.getClass());
    }

    @Override
    protected void reset() {
        this.mapper = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.mapper) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES, JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.registerModule(mapper, "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule");
        JSONEngineConfig config = ObjUtil.defaultIfNull(this.config, JSONEngineConfig::of);
        if (config.isPrettyPrint()) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        String dateFormat = config.getDateFormat();
        mapper.registerModule((Module)new TemporalModule(dateFormat));
        if (StrUtil.isNotEmpty(dateFormat)) {
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.setDateFormat((DateFormat)DateUtil.newSimpleFormat(dateFormat));
        }
        if (config.isIgnoreNullValue()) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        this.mapper = mapper;
    }

    private void registerModule(ObjectMapper mapper, String moduleClass) {
        Class<?> aClass;
        try {
            aClass = Class.forName(moduleClass);
        }
        catch (ClassNotFoundException ignore) {
            return;
        }
        mapper.registerModule((Module)ConstructorUtil.newInstance(aClass, new Object[0]));
    }
}

