/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;

public class JSONPrimitiveDeserializer
implements MatcherJSONDeserializer<Object> {
    public static final JSONPrimitiveDeserializer INSTANCE = new JSONPrimitiveDeserializer();

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return json instanceof JSONPrimitive && JSONPrimitive.isTypeForJSONPrimitive(TypeUtil.getClass(deserializeType));
    }

    @Override
    public Object deserialize(JSON json, Type deserializeType) {
        Object value = json.asJSONPrimitive().getValue();
        if (null != value && TypeUtil.getClass(deserializeType).isAssignableFrom(value.getClass())) {
            return value;
        }
        return ConvertUtil.convertWithCheck(deserializeType, value, null, ObjUtil.apply(json.config(), JSONConfig::isIgnoreError));
    }
}

