/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONUtil;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class ResourceBundleSerializer
implements MatcherJSONSerializer<ResourceBundle> {
    public static final ResourceBundleSerializer INSTANCE = new ResourceBundleSerializer();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof ResourceBundle;
    }

    @Override
    public JSON serialize(ResourceBundle bean, JSONContext context) {
        JSONObject result = context.getOrCreateObj();
        this.mapFromResourceBundle(bean, result);
        return result;
    }

    private void mapFromResourceBundle(ResourceBundle bundle, JSONObject jsonObject) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            ResourceBundleSerializer.propertyPut(jsonObject, key, bundle.getString(key));
        }
    }

    private static void propertyPut(JSONObject jsonObject, Object key, Object value) {
        String[] path = SplitUtil.splitToArray(ConvertUtil.toStr(key), ".");
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = JSONUtil.ofObj(target.config());
                target.putValue(segment, nextTarget);
            }
            target = nextTarget;
        }
        target.putValue(path[last], value);
    }
}

