/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.support;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.map.CaseInsensitiveLinkedMap;
import org.dromara.hutool.core.map.CaseInsensitiveTreeMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.serializer.JSONMapper;

public final class InternalJSONUtil {
    public static Object parseValueFromString(String string) {
        if (StrUtil.isEmpty(string) || "null".equalsIgnoreCase(string)) {
            return null;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        return InternalJSONUtil.parseNumberOrString(string);
    }

    public static Object parseNumberOrString(String string) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase(string, ".", "e")) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static CopyOptions toCopyOptions(JSONConfig config) {
        JSONMapper mapper = JSONFactory.of(config, null).getMapper();
        return CopyOptions.of().setIgnoreCase(config.isIgnoreCase()).setIgnoreError(config.isIgnoreError()).setIgnoreNullValue(config.isIgnoreNullValue()).setTransientSupport(config.isTransientSupport()).setConverter((targetType, value) -> mapper.toJSON(value, false));
    }

    public static void quote(CharSequence str, Appendable appendable) throws IORuntimeException {
        InternalJSONUtil.quote(str, appendable, true);
    }

    public static Appendable quote(CharSequence str, Appendable appendable, boolean isWrap) throws IORuntimeException {
        try {
            return InternalJSONUtil._quote(str, appendable, isWrap);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String escape(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            builder.append(InternalJSONUtil.escape(c));
        }
        return builder.toString();
    }

    public static Map<String, JSON> createRawMap(int capacity, JSONFactory factory) {
        JSONConfig config = ObjUtil.apply(factory, JSONFactory::getConfig);
        boolean ignoreCase = ObjUtil.defaultIfNull(config, JSONConfig::isIgnoreCase, false);
        Comparator keyComparator = ObjUtil.apply(config, JSONConfig::getKeyComparator);
        Map rawHashMap = ignoreCase ? (null != keyComparator ? new CaseInsensitiveTreeMap(keyComparator) : new CaseInsensitiveLinkedMap(capacity)) : (null != keyComparator ? new TreeMap(keyComparator) : new LinkedHashMap(capacity));
        return rawHashMap;
    }

    private static Appendable _quote(CharSequence str, Appendable writer, boolean isWrap) throws IOException {
        if (StrUtil.isEmpty(str)) {
            if (isWrap) {
                writer.append("\"\"");
            }
            return writer;
        }
        int len = str.length();
        if (isWrap) {
            writer.append('\"');
        }
        block3: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.append("\\");
                    writer.append(c);
                    continue block3;
                }
                default: {
                    writer.append(InternalJSONUtil.escape(c));
                }
            }
        }
        if (isWrap) {
            writer.append('\"');
        }
        return writer;
    }

    private static String escape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        if (c < ' ' || c >= '\u0080' && c <= '\u00a0' || c >= '\u2000' && c <= '\u2010' || c >= '\u2028' && c <= '\u202f' || c >= '\u2066' && c <= '\u206f') {
            return HexUtil.toUnicodeHex(c);
        }
        return Character.toString(c);
    }
}

