/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.log.engine.console;

import java.util.function.Function;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.lang.ansi.Ansi4BitColor;
import org.dromara.hutool.core.lang.ansi.AnsiEncoder;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.log.engine.console.ConsoleLog;
import org.dromara.hutool.log.level.Level;

public class ConsoleColorLog
extends ConsoleLog {
    private static final long serialVersionUID = 1L;
    private static final Ansi4BitColor COLOR_CLASSNAME = Ansi4BitColor.CYAN;
    private static final Ansi4BitColor COLOR_TIME = Ansi4BitColor.WHITE;
    private static final Ansi4BitColor COLOR_NONE = Ansi4BitColor.DEFAULT;
    private static Function<Level, Ansi4BitColor> colorFactory = level -> {
        switch (level) {
            case DEBUG: 
            case INFO: {
                return Ansi4BitColor.GREEN;
            }
            case WARN: {
                return Ansi4BitColor.YELLOW;
            }
            case ERROR: {
                return Ansi4BitColor.RED;
            }
            case TRACE: {
                return Ansi4BitColor.MAGENTA;
            }
        }
        return COLOR_NONE;
    };

    public static void setColorFactory(Function<Level, Ansi4BitColor> colorFactory) {
        ConsoleColorLog.colorFactory = colorFactory;
    }

    public ConsoleColorLog(String name) {
        super(name);
    }

    public ConsoleColorLog(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public synchronized void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        String template = AnsiEncoder.encode(COLOR_TIME, "[%s]", colorFactory.apply(level), "[%-5s]%s", COLOR_CLASSNAME, "%-30s: ", COLOR_NONE, "%s%n");
        System.out.format(template, DateUtil.formatNow(), level.name(), " - ", ClassUtil.getShortClassName(this.getName()), StrUtil.format(format, arguments));
    }
}

