/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.dromara.hutool.poi.excel.RowUtil;
import org.dromara.hutool.poi.excel.SheetUtil;
import org.dromara.hutool.poi.excel.cell.MergedCell;
import org.dromara.hutool.poi.excel.cell.NullCell;
import org.dromara.hutool.poi.excel.cell.editors.CellEditor;
import org.dromara.hutool.poi.excel.cell.editors.TrimEditor;
import org.dromara.hutool.poi.excel.cell.setters.CellSetterFactory;
import org.dromara.hutool.poi.excel.cell.values.CompositeCellValue;
import org.dromara.hutool.poi.excel.style.StyleSet;
import org.dromara.hutool.poi.excel.style.StyleUtil;

public class CellUtil {
    public static Object getCellValue(Cell cell) {
        return CellUtil.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return CellUtil.getCellValue(cell, cell.getCellType(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        return CellUtil.getCellValue(cell, null, cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        return CompositeCellValue.of(cell, cellType, cellEditor).getValue();
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        CellStyle cellStyle = null;
        if (null != styleSet) {
            cellStyle = styleSet.getStyleFor(new CellReference(cell), value, isHeader);
        }
        CellUtil.setCellValue(cell, value, cellStyle, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style, CellEditor cellEditor) {
        cell.setCellStyle(style);
        CellUtil.setCellValue(cell, value, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        if (null != cellEditor) {
            value = cellEditor.edit(cell, value);
        }
        CellUtil.setCellValue(cell, value);
    }

    public static void setCellValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (CellType.BLANK != cell.getCellType()) {
            cell.setBlank();
        }
        CellSetterFactory.createCellSetter(value).setValue(cell);
    }

    public static Cell getOrCreateCell(Sheet sheet, int x, int y) {
        return CellUtil.getCell(sheet, x, y, true);
    }

    public static Cell getCell(Sheet sheet, int x, int y, boolean isCreateIfNotExist) {
        Row row;
        Row row2 = row = isCreateIfNotExist ? RowUtil.getOrCreateRow(sheet, y) : sheet.getRow(y);
        if (null != row) {
            return isCreateIfNotExist ? CellUtil.getOrCreateCell(row, x) : row.getCell(x);
        }
        return null;
    }

    public static Cell getCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            return new NullCell(row, cellIndex);
        }
        return cell;
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return CellUtil.isMergedRegion(sheet, cellReference.getCol(), cellReference.getRow());
    }

    public static boolean isMergedRegion(Cell cell) {
        return CellUtil.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return CellUtil.mergingCells(sheet, cellRangeAddress, null);
    }

    public static int mergingCells(Sheet sheet, CellRangeAddress cellRangeAddress, CellStyle cellStyle) {
        if (cellRangeAddress.getNumberOfCells() <= 1) {
            return -1;
        }
        StyleUtil.setBorderStyle(sheet, cellRangeAddress, cellStyle);
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Cell getFirstCellOfMerged(Cell cell) {
        if (null == cell) {
            return null;
        }
        MergedCell mergedCell = CellUtil.getMergedCell(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
        if (null != mergedCell) {
            return mergedCell.getFirst();
        }
        return cell;
    }

    public static MergedCell getMergedCell(Sheet sheet, int x, int y) {
        if (null == sheet) {
            return null;
        }
        CellRangeAddress mergedRegion = SheetUtil.getMergedRegion(sheet, x, y);
        if (null != mergedRegion) {
            return MergedCell.of(CellUtil.getCell(sheet, mergedRegion.getFirstColumn(), mergedRegion.getFirstRow(), false), mergedRegion);
        }
        return null;
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor) {
        CellUtil.setComment(cell, commentText, commentAuthor, null);
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor, ClientAnchor anchor) {
        Sheet sheet = cell.getSheet();
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        if (anchor == null) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        }
        Comment comment = sheet.createDrawingPatriarch().createCellComment(anchor);
        comment.setAddress(cell.getAddress());
        comment.setString(factory.createRichTextString(commentText));
        if (null != commentAuthor) {
            comment.setAuthor(commentAuthor);
        }
        cell.setCellComment(comment);
    }

    public static void remove(Cell cell) {
        if (null != cell) {
            cell.getRow().removeCell(cell);
        }
    }
}

