/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.style;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.excel.style.CellBorderStyle;

public class StyleUtil {
    public static CellStyle createCellStyle(Workbook workbook) {
        if (null == workbook) {
            return null;
        }
        return workbook.createCellStyle();
    }

    public static CellStyle createDefaultCellStyle(Workbook workbook) {
        CellStyle cellStyle = StyleUtil.createCellStyle(workbook);
        StyleUtil.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StyleUtil.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        return cellStyle;
    }

    public static CellStyle createHeadCellStyle(Workbook workbook) {
        CellStyle cellStyle = StyleUtil.createCellStyle(workbook);
        StyleUtil.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StyleUtil.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        StyleUtil.setColor(cellStyle, IndexedColors.GREY_25_PERCENT, FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    public static boolean isNullOrDefaultStyle(Workbook workbook, CellStyle style) {
        return null == style || style.equals(workbook.getCellStyleAt(0));
    }

    public static CellStyle cloneCellStyle(Cell cell, CellStyle cellStyle) {
        return StyleUtil.cloneCellStyle(cell.getSheet().getWorkbook(), cellStyle);
    }

    public static CellStyle cloneCellStyle(Workbook workbook, CellStyle cellStyle) {
        CellStyle newCellStyle = StyleUtil.createCellStyle(workbook);
        newCellStyle.cloneStyleFrom(cellStyle);
        return newCellStyle;
    }

    public static CellStyle setAlign(CellStyle cellStyle, HorizontalAlignment halign, VerticalAlignment valign) {
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        return cellStyle;
    }

    public static CellStyle setBorder(CellStyle cellStyle, BorderStyle borderSize, IndexedColors colorIndex) {
        return StyleUtil.setBorder(cellStyle, CellBorderStyle.of(borderSize, colorIndex));
    }

    public static CellStyle setBorder(CellStyle cellStyle, CellBorderStyle cellBorderStyle) {
        return cellBorderStyle.setTo(cellStyle);
    }

    public static void setBorderStyle(Sheet sheet, CellRangeAddress cellRangeAddress, CellBorderStyle cellBorderStyle) {
        if (null != cellBorderStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellBorderStyle.getTopStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellBorderStyle.getRightStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellBorderStyle.getBottomStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellBorderStyle.getLeftStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setTopBorderColor((int)cellBorderStyle.getTopColor().shortValue(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setRightBorderColor((int)cellBorderStyle.getRightColor().shortValue(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setLeftBorderColor((int)cellBorderStyle.getLeftColor().shortValue(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBottomBorderColor((int)cellBorderStyle.getBottomColor().shortValue(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
    }

    public static void setBorderStyle(Sheet sheet, CellRangeAddress cellRangeAddress, CellStyle cellStyle) {
        if (null != cellStyle) {
            CellBorderStyle cellBorderStyle = CellBorderStyle.of(cellStyle);
            StyleUtil.setBorderStyle(sheet, cellRangeAddress, cellBorderStyle);
        }
    }

    public static CellStyle setColor(CellStyle cellStyle, IndexedColors color, FillPatternType fillPattern) {
        return StyleUtil.setColor(cellStyle, color.index, fillPattern);
    }

    public static CellStyle setColor(CellStyle cellStyle, short color, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(color);
        cellStyle.setFillPattern(ObjUtil.defaultIfNull(fillPattern, FillPatternType.SOLID_FOREGROUND));
        return cellStyle;
    }

    public static CellStyle setColor(XSSFCellStyle cellStyle, XSSFColor color, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(color);
        cellStyle.setFillPattern(ObjUtil.defaultIfNull(fillPattern, FillPatternType.SOLID_FOREGROUND));
        return cellStyle;
    }

    public static Font createFont(Workbook workbook, short color, short fontSize, String fontName) {
        Font font = workbook.createFont();
        return StyleUtil.setFontStyle(font, color, fontSize, fontName);
    }

    public static Font setFontStyle(Font font, short color, short fontSize, String fontName) {
        if (color > 0) {
            font.setColor(color);
        }
        if (fontSize > 0) {
            font.setFontHeightInPoints(fontSize);
        }
        if (StrUtil.isNotBlank(fontName)) {
            font.setFontName(fontName);
        }
        return font;
    }

    public static Short getFormat(Workbook workbook, String format) {
        DataFormat dataFormat = workbook.createDataFormat();
        return dataFormat.getFormat(format);
    }
}

