/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.LineReader;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.SystemUtil;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.setting.GroupedMap;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private final Charset charset;
    private final boolean isUseVariable;
    private final GroupedMap groupedMap;
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private UnaryOperator<String> valueEditor;

    public SettingLoader(GroupedMap groupedMap) {
        this(groupedMap, CharsetUtil.UTF_8, false);
    }

    public SettingLoader(GroupedMap groupedMap, Charset charset, boolean isUseVariable) {
        this.groupedMap = groupedMap;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", resource);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            boolean bl;
            try {
                log.error(e, "Load setting error!", new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(settingStream);
                throw throwable;
            }
            IoUtil.closeQuietly(settingStream);
            return bl;
        }
        IoUtil.closeQuietly(settingStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream settingStream) throws IOException {
        this.groupedMap.clear();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank(line = StrUtil.trim(line)) || StrUtil.startWith((CharSequence)line, '#')) continue;
                if (StrUtil.isWrap((CharSequence)line, '[', ']')) {
                    group = StrUtil.trim(line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = SplitUtil.split(line, String.valueOf(this.assignFlag), 2, true, false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = (String)this.valueEditor.apply(value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupedMap.put(group, StrUtil.trim(keyValue[0]), value);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
    }

    public SettingLoader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public SettingLoader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public SettingLoader setValueEditor(UnaryOperator<String> valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    public void store(String absolutePath) {
        this.store(FileUtil.touch(absolutePath));
    }

    public void store(File file) {
        Assert.notNull(file, "File to store must be not null !", new Object[0]);
        log.debug("Store Setting to [{}]...", file.getAbsolutePath());
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(file, this.charset, false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(writer);
            throw throwable;
        }
        IoUtil.closeQuietly(writer);
    }

    private synchronized void store(PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            writer.println(StrUtil.format("{}{}{}", Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(StrUtil.format("{} {} {}", entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()));
            }
        }
    }

    private String replaceVar(String group, String value) {
        Set vars = ReUtil.findAll(this.varRegex, (CharSequence)value, 0, new HashSet());
        for (String var : vars) {
            List<String> groupAndKey;
            String key = ReUtil.get(this.varRegex, (CharSequence)var, 1);
            if (!StrUtil.isNotBlank(key)) continue;
            String varValue = this.groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = SplitUtil.split(key, ".", 2, true, false)).size() > 1) {
                varValue = this.groupedMap.get(groupAndKey.get(0), groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = SystemUtil.get(key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

