/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.annotation.ReadableBean;
import org.dromara.hutool.core.annotation.WritableBean;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanDesc;
import org.dromara.hutool.core.bean.BeanDescFactory;
import org.dromara.hutool.core.bean.BeanException;
import org.dromara.hutool.core.bean.BeanInfoCache;
import org.dromara.hutool.core.bean.DynaBean;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.RecordUtil;
import org.dromara.hutool.core.bean.copier.BeanCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.bean.path.BeanPath;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.convert.impl.RecordConverter;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.BeanMap;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.map.Dict;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class BeanUtil {
    public static DynaBean createDynaBean(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescFactory.getBeanDesc(clazz);
    }

    public static void descForEach(Class<?> clazz, Consumer<? super PropDesc> action) {
        BeanUtil.getBeanDesc(clazz).getProps().forEach(action);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), t -> !"class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanUtil.internalGetPropertyDescriptorMap(clazz, ignoreCase));
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanUtil.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanUtil.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static <T> T getProperty(Object bean, String expression) {
        Map map;
        if (null == bean || StrUtil.isBlank(expression)) {
            return null;
        }
        if (bean instanceof Map && (map = (Map)bean).containsKey(expression)) {
            return (T)map.get(expression);
        }
        return (T)BeanPath.of(expression).getValue(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        BeanPath.of(expression).setValue(bean, value);
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanUtil.toBean(source, clazz, null);
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        return (T)BeanUtil.toBean(source, () -> ConstructorUtil.newInstanceIfPossible(clazz), options);
    }

    public static <T> T toBean(Object source, Supplier<T> targetSupplier, CopyOptions options) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        BeanUtil.copyProperties(source, target, options);
        return target;
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.of(valueProvider, bean, copyOptions).copy();
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        return BeanUtil.copyProperties(map, bean, copyOptions);
    }

    public static Map<String, Object> toBeanMap(Object bean) {
        return BeanMap.of(bean);
    }

    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        int mapSize = 16;
        UnaryOperator editor = null;
        if (ArrayUtil.isNotEmpty(properties)) {
            mapSize = properties.length;
            HashSet<String> propertiesSet = SetUtil.of(properties);
            editor = entry -> {
                String key = StrUtil.toStringOrNull(entry.getKey());
                entry.setKey(propertiesSet.contains(key) ? key : null);
                return entry;
            };
        }
        return BeanUtil.beanToMap(bean, new LinkedHashMap(mapSize, 1.0f), false, editor);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanUtil.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanUtil.beanToMap(bean, targetMap, ignoreNullValue, entry -> {
            String key = StrUtil.toStringOrNull(entry.getKey());
            entry.setKey(isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key);
            return entry;
        });
    }

    public static <V> Map<String, V> beanToMap(Object bean, Map<String, V> targetMap, boolean ignoreNullValue, UnaryOperator<MutableEntry<Object, Object>> keyEditor) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, CopyOptions.of().setIgnoreNullValue(ignoreNullValue).setFieldEditor(keyEditor)).copy();
    }

    public static <V> Map<String, V> beanToMap(Object bean, Map<String, V> targetMap, CopyOptions copyOptions) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, copyOptions).copy();
    }

    public static <T> T copyProperties(Object source, Class<T> tClass, String ... ignoreProperties) {
        if (null == source) {
            return null;
        }
        if (RecordUtil.isRecord(tClass)) {
            return RecordConverter.INSTANCE.convert(tClass, source);
        }
        T target = ConstructorUtil.newInstanceIfPossible(tClass);
        return BeanUtil.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
    }

    public static <T> T copyProperties(Object source, T target, String ... ignoreProperties) {
        return BeanUtil.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
    }

    public static <T> T copyProperties(Object source, T target, boolean ignoreCase) {
        return BeanCopier.of(source, target, CopyOptions.of().setIgnoreCase(ignoreCase)).copy();
    }

    public static <T> T copyProperties(Object source, T target, CopyOptions copyOptions) {
        if (null == source || null == target) {
            return null;
        }
        return BeanCopier.of(source, target, ObjUtil.defaultIfNull(copyOptions, CopyOptions::of)).copy();
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType) {
        return BeanUtil.copyToList(collection, targetType, CopyOptions.of());
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType, CopyOptions copyOptions) {
        if (null == collection) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList(0);
        }
        if (ClassUtil.isBasicType(targetType) || String.class == targetType) {
            return ConvertUtil.toList(targetType, collection);
        }
        return collection.stream().map(source -> {
            Object target = ConstructorUtil.newInstanceIfPossible(targetType);
            BeanUtil.copyProperties(source, target, copyOptions);
            return target;
        }).collect(Collectors.toList());
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        if (null == bean || StrUtil.isBlank(beanClassName)) {
            return false;
        }
        return ClassUtil.getClassName(bean, isSimple).equals(isSimple ? StrUtil.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T edit(T bean, UnaryOperator<Field> editor) {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        for (Field field : fields = FieldUtil.getFields(bean.getClass())) {
            if (ModifierUtil.isStatic(field)) continue;
            editor.apply(field);
        }
        return bean;
    }

    public static <T> T trimStrFields(T bean, String ... ignoreFields) {
        return BeanUtil.edit(bean, field -> {
            String trimVal;
            String val;
            if (ignoreFields != null && ArrayUtil.containsIgnoreCase(ignoreFields, field.getName())) {
                return field;
            }
            if (String.class.equals(field.getType()) && null != (val = (String)FieldUtil.getFieldValue(bean, field)) && !val.equals(trimVal = StrUtil.trim(val))) {
                FieldUtil.setFieldValue(bean, field, (Object)trimVal);
            }
            return field;
        });
    }

    public static boolean isEmpty(Object bean, String ... ignoreFieldNames) {
        return !BeanUtil.isNotEmpty(bean, ignoreFieldNames);
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFieldNames) {
        if (null == bean) {
            return false;
        }
        return BeanUtil.checkBean(bean, field -> !ArrayUtil.contains(ignoreFieldNames, field.getName()) && null != FieldUtil.getFieldValue(bean, field));
    }

    public static boolean isReadableBean(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        if (clazz == String.class) {
            return false;
        }
        if (AnnotationUtil.hasAnnotation(clazz, ReadableBean.class)) {
            return true;
        }
        return BeanUtil.hasGetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean isWritableBean(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        if (Dict.class == clazz) {
            return false;
        }
        if (AnnotationUtil.hasAnnotation(clazz, WritableBean.class)) {
            return true;
        }
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getParameterCount() != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || "getClass".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtil.isPublic(field) || ModifierUtil.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNullField(Object bean, String ... ignoreFieldNames) {
        return BeanUtil.checkBean(bean, field -> !ArrayUtil.contains(ignoreFieldNames, field.getName()) && null == FieldUtil.getFieldValue(bean, field));
    }

    public static boolean hasEmptyField(Object bean, String ... ignoreFieldNames) {
        return BeanUtil.checkBean(bean, field -> !ArrayUtil.contains(ignoreFieldNames, field.getName()) && StrUtil.isEmptyIfStr(FieldUtil.getFieldValue(bean, field)));
    }

    public static boolean checkBean(Object bean, Predicate<Field> predicate) {
        if (null == bean) {
            return true;
        }
        for (Field field : FieldUtil.getFields(bean.getClass())) {
            if (ModifierUtil.isStatic(field) || !predicate.test(field)) continue;
            return true;
        }
        return false;
    }

    public static String getFieldName(String getterOrSetterName) {
        if (getterOrSetterName.startsWith("get") || getterOrSetterName.startsWith("set")) {
            return StrUtil.removePreAndLowerFirst((CharSequence)getterOrSetterName, 3);
        }
        if (getterOrSetterName.startsWith("is")) {
            return StrUtil.removePreAndLowerFirst((CharSequence)getterOrSetterName, 2);
        }
        throw new IllegalArgumentException("Invalid Getter or Setter name: " + getterOrSetterName);
    }
}

