/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.unit;

import org.dromara.hutool.core.io.unit.DataSize;
import org.dromara.hutool.core.text.StrUtil;

public enum DataUnit {
    BYTES("B", DataSize.ofBytes(1L)),
    KILOBYTES("KB", DataSize.ofKilobytes(1L)),
    MEGABYTES("MB", DataSize.ofMegabytes(1L)),
    GIGABYTES("GB", DataSize.ofGigabytes(1L)),
    TERABYTES("TB", DataSize.ofTerabytes(1L));

    public static final String[] UNIT_NAMES;
    public static final String[] UNIT_NAMES_SIMPLE;
    private final String suffix;
    private final DataSize size;

    private DataUnit(String suffix, DataSize size) {
        this.suffix = suffix;
        this.size = size;
    }

    public String getSuffix() {
        return this.suffix;
    }

    DataSize getSize() {
        return this.size;
    }

    public static DataUnit fromSuffix(String suffix) {
        for (DataUnit candidate : DataUnit.values()) {
            if (!StrUtil.startWithIgnoreCase(candidate.suffix, suffix)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unknown data unit suffix '" + suffix + "'");
    }

    static {
        UNIT_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
        UNIT_NAMES_SIMPLE = new String[]{"B", "K", "M", "G", "T", "P", "E"};
    }
}

