/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.pool.partition;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.pool.ObjectFactory;
import org.dromara.hutool.core.pool.ObjectPool;
import org.dromara.hutool.core.pool.PoolConfig;
import org.dromara.hutool.core.pool.PoolException;
import org.dromara.hutool.core.pool.Poolable;
import org.dromara.hutool.core.pool.partition.PartitionPoolable;

public class PoolPartition<T>
implements ObjectPool<T> {
    private static final long serialVersionUID = 1L;
    private final PoolConfig config;
    private final ObjectFactory<T> objectFactory;
    private BlockingQueue<Poolable<T>> queue;
    private int total;

    public PoolPartition(PoolConfig config, BlockingQueue<Poolable<T>> queue, ObjectFactory<T> objectFactory) {
        this.config = config;
        this.queue = queue;
        this.objectFactory = objectFactory;
        this.doIncrease(config.getMinSize());
    }

    @Override
    public T borrowObject() {
        Poolable<T> poolable = (Poolable<T>)this.queue.poll();
        if (null != poolable) {
            long maxIdle;
            Object obj = poolable.getRaw();
            if (this.objectFactory.validate(obj) && ((maxIdle = this.config.getMaxIdle()) <= 0L || poolable.getIdle() <= maxIdle)) {
                return obj;
            }
            this.free(obj);
            return this.borrowObject();
        }
        if (this.increase(1) <= 0 && null == (poolable = this.waitingPoll())) {
            throw new PoolException("Pool exhausted!");
        }
        return this.borrowObject();
    }

    @Override
    public PoolPartition<T> returnObject(T obj) {
        if (this.objectFactory.validate(obj)) {
            try {
                this.queue.put(this.wrapPoolable(obj));
            }
            catch (InterruptedException e) {
                throw new PoolException(e);
            }
        } else {
            this.free((Object)obj);
        }
        return this;
    }

    public synchronized int increase(int increaseSize) {
        return this.doIncrease(increaseSize);
    }

    @Override
    public synchronized PoolPartition<T> free(T obj) {
        this.objectFactory.destroy(obj);
        --this.total;
        return this;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getIdleCount() {
        return this.queue.size();
    }

    @Override
    public int getActiveCount() {
        return this.getTotal() - this.getIdleCount();
    }

    @Override
    public synchronized void close() throws IOException {
        this.queue.forEach(poolable -> this.objectFactory.destroy(poolable.getRaw()));
        this.queue.clear();
        this.queue = null;
        this.total = 0;
    }

    protected Poolable<T> createPoolable() {
        T t = this.objectFactory.create();
        Assert.notNull(t, "Null object created and not allow!", new Object[0]);
        return this.wrapPoolable(t);
    }

    private Poolable<T> wrapPoolable(T t) {
        return new PartitionPoolable<T>(t, this);
    }

    private int doIncrease(int increaseSize) {
        int maxSize = this.config.getMaxSize();
        if (increaseSize + this.total > maxSize) {
            increaseSize = maxSize - this.total;
        }
        try {
            for (int i = 0; i < increaseSize; ++i) {
                this.queue.put(this.createPoolable());
            }
            this.total += increaseSize;
        }
        catch (InterruptedException e) {
            throw new PoolException(e);
        }
        return increaseSize;
    }

    private Poolable<T> waitingPoll() throws PoolException {
        long maxWait = this.config.getMaxWait();
        try {
            if (maxWait <= 0L) {
                return this.queue.take();
            }
            return this.queue.poll(maxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new PoolException(e);
        }
    }
}

