/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.Mode;
import org.dromara.hutool.crypto.Padding;
import org.dromara.hutool.crypto.symmetric.SymmetricAlgorithm;
import org.dromara.hutool.crypto.symmetric.SymmetricCrypto;

public class DES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public DES() {
        super(SymmetricAlgorithm.DES);
    }

    public DES(byte[] key) {
        super(SymmetricAlgorithm.DES, key);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, KeyUtil.generateKey("DES", key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, KeyUtil.generateKey("DES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StrUtil.format("DES/{}/{}", mode, padding), key, iv);
    }
}

