/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.config;

import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.sql.filter.SqlFilter;
import org.dromara.hutool.db.sql.filter.SqlFilterChain;

public class DbConfig
extends ConnectionConfig<DbConfig> {
    private boolean caseInsensitive = true;
    private SqlFilterChain sqlFilters;
    private DSFactory dsFactory;
    private Dialect dialect;

    public static DbConfig of(String url, String user, String pass) {
        return (DbConfig)((DbConfig)((DbConfig)((DbConfig)DbConfig.of().setUrl(url)).setUser(user)).setPass(pass)).setDriver(DriverUtil.identifyDriver(url));
    }

    public static DbConfig of() {
        return new DbConfig();
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public DbConfig setCaseInsensitive(boolean isCaseInsensitive) {
        this.caseInsensitive = isCaseInsensitive;
        return this;
    }

    public SqlFilterChain getSqlFilters() {
        return this.sqlFilters;
    }

    public DbConfig addSqlFilter(SqlFilter filter) {
        if (null == this.sqlFilters) {
            this.sqlFilters = new SqlFilterChain();
        }
        this.sqlFilters.addChain(filter);
        return this;
    }

    public DSFactory getDsFactory() {
        return this.dsFactory;
    }

    public DbConfig setDsFactory(DSFactory dsFactory) {
        this.dsFactory = dsFactory;
        return this;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public DbConfig setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }
}

