/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.httpclient5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.engine.EngineRequestBuilder;
import org.dromara.hutool.http.client.engine.httpclient5.HttpClient5BodyEntity;
import org.dromara.hutool.http.meta.HeaderName;

public class ClassicHttpRequestBuilder
implements EngineRequestBuilder<ClassicHttpRequest> {
    public static ClassicHttpRequestBuilder INSTANCE = new ClassicHttpRequestBuilder();

    @Override
    public ClassicHttpRequest build(Request message) {
        UrlBuilder url = message.handledUrl();
        Assert.notNull(url, "Request URL must be not null!", new Object[0]);
        HttpUriRequestBase request = new HttpUriRequestBase(message.method().name(), url.toURI());
        request.setConfig(ClassicHttpRequestBuilder.buildRequestConfig(message));
        request.setHeaders(ClassicHttpRequestBuilder.toHeaderList(message.headers()).toArray(new Header[0]));
        HttpBody body = message.handledBody();
        if (null != body) {
            request.setEntity((HttpEntity)new HttpClient5BodyEntity(message.header(HeaderName.CONTENT_TYPE), message.contentEncoding(), message.isChunked(), body));
        }
        return request;
    }

    private static List<Header> toHeaderList(Map<String, ? extends Collection<String>> headersMap) {
        ArrayList<Header> result = new ArrayList<Header>();
        headersMap.forEach((k, v1) -> v1.forEach(v2 -> result.add((Header)new BasicHeader(k, v2))));
        return result;
    }

    private static RequestConfig buildRequestConfig(Request request) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        int maxRedirects = request.maxRedirects();
        if (maxRedirects > 0) {
            requestConfigBuilder.setMaxRedirects(maxRedirects);
        } else {
            requestConfigBuilder.setRedirectsEnabled(false);
        }
        return requestConfigBuilder.build();
    }
}

