/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.http.HttpException;

public class ProxyInfo {
    private String authHost;
    private int authPort;
    private ProxySelector proxySelector;
    private PasswordAuthentication auth;

    public ProxyInfo(final String host, final int port) {
        this(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return ListUtil.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                throw new HttpException(ioe);
            }
        }, null);
        this.authHost = host;
        this.authPort = port;
    }

    public ProxyInfo(ProxySelector proxySelector, PasswordAuthentication auth) {
        this.proxySelector = proxySelector;
        this.auth = auth;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public Proxy selectFirst(URI uri) {
        List<Proxy> select;
        if (null != this.proxySelector && CollUtil.isNotEmpty(select = this.proxySelector.select(uri))) {
            return select.get(0);
        }
        return null;
    }

    public ProxyInfo setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public ProxyInfo setAuth(String user, char[] pass) {
        return this.setAuth(new PasswordAuthentication(user, pass));
    }

    public ProxyInfo setAuth(PasswordAuthentication auth) {
        this.auth = auth;
        return this;
    }

    public PasswordAuthentication getAuth() {
        return this.auth;
    }
}

