/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.smart;

import javax.net.ssl.SSLContext;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.AbstractServerEngine;
import org.dromara.hutool.http.server.engine.smart.SmartHttpRequest;
import org.dromara.hutool.http.server.engine.smart.SmartHttpResponse;
import org.smartboot.http.server.HttpBootstrap;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;

public class SmartHttpServerEngine
extends AbstractServerEngine {
    private HttpBootstrap bootstrap;

    public SmartHttpServerEngine() {
        Assert.notNull(HttpBootstrap.class);
    }

    @Override
    public void start() {
        this.initEngine();
        this.bootstrap.start();
    }

    public HttpBootstrap getRawEngine() {
        return this.bootstrap;
    }

    @Override
    protected void reset() {
        if (null != this.bootstrap) {
            this.bootstrap.shutdown();
            this.bootstrap = null;
        }
    }

    @Override
    protected void initEngine() {
        long idleTimeout;
        int coreThreads;
        if (null != this.bootstrap) {
            return;
        }
        HttpBootstrap bootstrap = new HttpBootstrap();
        HttpServerConfiguration configuration = bootstrap.configuration();
        ServerConfig config = this.config;
        configuration.host(config.getHost());
        SSLContext sslContext = config.getSslContext();
        if (null != sslContext) {
            SslPlugin sslPlugin;
            try {
                sslPlugin = new SslPlugin(() -> sslContext);
            }
            catch (Exception e) {
                throw new HttpException(e);
            }
            configuration.addPlugin((Plugin)sslPlugin);
        }
        if ((coreThreads = config.getCoreThreads()) > 0) {
            configuration.threadNum(coreThreads);
        }
        if ((idleTimeout = config.getIdleTimeout()) > 0L) {
            configuration.setHttpIdleTimeout((int)idleTimeout);
        }
        bootstrap.httpHandler(new HttpServerHandler(){

            public void handle(HttpRequest request, HttpResponse response) {
                SmartHttpServerEngine.this.handler.handle(new SmartHttpRequest(request), new SmartHttpResponse(response));
            }
        });
        bootstrap.setPort(config.getPort());
        this.bootstrap = bootstrap;
    }
}

