/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.sun;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.sun.HttpExchangeWrapper;
import org.dromara.hutool.http.server.engine.sun.SunHttpServerEngine;
import org.dromara.hutool.http.server.engine.sun.filter.HttpFilter;
import org.dromara.hutool.http.server.engine.sun.filter.SimpleFilter;
import org.dromara.hutool.http.server.handler.HttpHandler;
import org.dromara.hutool.http.server.handler.RootHandler;

public class SimpleServer {
    private final SunHttpServerEngine engine = new SunHttpServerEngine();

    public SimpleServer(int port) {
        this(new InetSocketAddress(port));
    }

    public SimpleServer(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public SimpleServer(InetSocketAddress address) {
        this(address, null);
    }

    public SimpleServer(InetSocketAddress address, SSLContext sslContext) {
        ServerConfig serverConfig = ServerConfig.of().setHost(address.getHostName()).setPort(address.getPort()).setSslContext(sslContext);
        this.engine.init(serverConfig);
    }

    public SimpleServer addFilter(Filter filter) {
        this.engine.addFilter(filter);
        return this;
    }

    public SimpleServer addFilter(final HttpFilter filter) {
        return this.addFilter(new SimpleFilter(){

            @Override
            public void doFilter(HttpExchange httpExchange, Filter.Chain chain) throws IOException {
                HttpExchangeWrapper httpExchangeWrapper = new HttpExchangeWrapper(httpExchange);
                filter.doFilter(httpExchangeWrapper.getRequest(), httpExchangeWrapper.getResponse(), chain);
            }
        });
    }

    public SimpleServer addHandler(String path, com.sun.net.httpserver.HttpHandler handler) {
        this.createContext(path, handler);
        return this;
    }

    public HttpContext createContext(String path, com.sun.net.httpserver.HttpHandler handler) {
        path = StrUtil.addPrefixIfNot(path, "/");
        return this.engine.createContext(path, handler);
    }

    public SimpleServer addAction(String path, HttpHandler action) {
        return this.addHandler(path, exchange -> {
            HttpExchangeWrapper exchangeWrapper = new HttpExchangeWrapper(exchange);
            action.handle(exchangeWrapper.getRequest(), exchangeWrapper.getResponse());
        });
    }

    public SimpleServer setRoot(String root) {
        return this.setRoot(new File(root));
    }

    public SimpleServer setRoot(File root) {
        this.addAction("/", new RootHandler(root));
        return this;
    }

    public SimpleServer setExecutor(Executor executor) {
        this.engine.setExecutor(executor);
        return this;
    }

    public HttpServer getRawServer() {
        return this.engine.getRawEngine();
    }

    public InetSocketAddress getAddress() {
        return this.getRawServer().getAddress();
    }

    public void start() {
        InetSocketAddress address = this.getAddress();
        Console.log("Hutool Simple Http Server listen on \u3010{}:{}\u3011", address.getHostName(), address.getPort());
        this.engine.start();
    }
}

