/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.engine.gson.GsonTypeAdapter;

public class TemporalGsonTypeAdapter
implements GsonTypeAdapter<TemporalAccessor> {
    private final Class<? extends TemporalAccessor> type;
    private final String dateFormat;

    public TemporalGsonTypeAdapter(Class<? extends TemporalAccessor> type, String dateFormat) {
        this.type = type;
        this.dateFormat = dateFormat;
    }

    public JsonElement serialize(TemporalAccessor src, Type typeOfSrc, JsonSerializationContext context) {
        return StrUtil.isEmpty(this.dateFormat) ? new JsonPrimitive((Number)TimeUtil.toEpochMilli(src)) : new JsonPrimitive(TimeUtil.format(src, this.dateFormat));
    }

    public TemporalAccessor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return StrUtil.isEmpty(this.dateFormat) ? ConvertUtil.convert(this.type, (Object)json.getAsLong()) : ConvertUtil.convert(this.type, (Object)TimeUtil.parse((CharSequence)json.getAsString(), this.dateFormat));
    }
}

