/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;
import org.dromara.hutool.json.serializer.impl.IterTypeAdapter;

public class MapTypeAdapter
implements MatcherJSONSerializer<Map<?, ?>>,
MatcherJSONDeserializer<Map<?, ?>> {
    public static final MapTypeAdapter INSTANCE = new MapTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof Map;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        if (json instanceof JSONObject) {
            Class<?> rawType = TypeUtil.getClass(deserializeType);
            return Map.class.isAssignableFrom(rawType);
        }
        return false;
    }

    @Override
    public JSON serialize(Map<?, ?> bean, JSONContext context) {
        JSON contextJson = context.getContextJson();
        if (contextJson instanceof JSONArray) {
            Iterator<Object> iter = bean instanceof Iterator ? (Iterator)((Object)bean) : (bean instanceof Iterable ? ((Iterable)((Object)bean)).iterator() : bean.entrySet().iterator());
            IterTypeAdapter.mapFromIterator(bean, iter, (JSONArray)contextJson);
            return contextJson;
        }
        JSONObject result = context.getOrCreateObj();
        for (Map.Entry<?, ?> e : bean.entrySet()) {
            result.putValue(StrUtil.toStringOrNull(e.getKey()), e.getValue());
        }
        return result;
    }

    @Override
    public Map<?, ?> deserialize(JSON json, Type deserializeType) {
        Type keyType = TypeUtil.getTypeArgument(deserializeType, 0);
        Type valueType = TypeUtil.getTypeArgument(deserializeType, 1);
        return this.toMap(json, TypeUtil.getClass(deserializeType), keyType, valueType);
    }

    public Map<?, ?> toMap(JSON json, Class<?> mapClass, Type keyType, Type valueType) {
        Map map = MapUtil.createMap(mapClass, LinkedHashMap::new);
        for (Map.Entry entry : (JSONObject)json) {
            map.put(ConvertUtil.convert(keyType, entry.getKey()), ObjUtil.apply(entry.getValue(), value -> value.toBean(valueType)));
        }
        return map;
    }
}

