/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.support;

import org.dromara.hutool.core.bean.path.BeanPath;
import org.dromara.hutool.core.bean.path.NodeBeanFactory;
import org.dromara.hutool.core.bean.path.node.EmptyNode;
import org.dromara.hutool.core.bean.path.node.ListNode;
import org.dromara.hutool.core.bean.path.node.NameNode;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.bean.path.node.RangeNode;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONUtil;

public class JSONNodeBeanFactory
implements NodeBeanFactory<JSON> {
    private final JSONConfig config;

    public JSONNodeBeanFactory(JSONConfig config) {
        this.config = config;
    }

    @Override
    public JSON create(JSON parent, BeanPath<JSON> beanPath) {
        Node node;
        Object next = beanPath.next();
        if (null != next && (node = ((BeanPath)next).getNode()) instanceof NameNode) {
            NameNode nameNode = (NameNode)node;
            if (nameNode.isNumber()) {
                return JSONUtil.ofArray(this.config);
            }
            return JSONUtil.ofObj(this.config);
        }
        return JSONUtil.ofObj(this.config);
    }

    @Override
    public Object getValue(JSON bean, BeanPath<JSON> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return null;
        }
        if (node instanceof ListNode) {
            return this.getValueByListNode(bean, (ListNode)node);
        }
        if (node instanceof NameNode) {
            return this.getValueByNameNode(bean, (NameNode)node);
        }
        if (node instanceof RangeNode) {
            return this.getValueByRangeNode(bean, (RangeNode)node);
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    @Override
    public JSON setValue(JSON bean, Object value, BeanPath<JSON> beanPath) {
        Node node = beanPath.getNode();
        if (node instanceof EmptyNode) {
            return bean;
        }
        if (node instanceof NameNode) {
            if (bean instanceof JSONObject) {
                ((JSONObject)bean).putValue(((NameNode)node).getName(), value);
            } else if (bean instanceof JSONArray) {
                ((JSONArray)bean).setValue(Integer.parseInt(((NameNode)node).getName()), value);
            }
            return bean;
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    private Object getValueByListNode(JSON bean, ListNode node) {
        String[] names = node.getUnWrappedNames();
        if (bean instanceof JSONArray) {
            return CollUtil.getAny((JSONArray)bean, ConvertUtil.convert(int[].class, (Object)names));
        }
        if (bean instanceof JSONObject) {
            MapUtil.getAny((JSONObject)bean, names);
        }
        throw new UnsupportedOperationException("Can not get by list for: " + bean.getClass());
    }

    private Object getValueByNameNode(JSON bean, NameNode node) {
        String name = node.getName();
        if ("$".equals(name)) {
            return bean;
        }
        if (bean instanceof JSONObject) {
            return ((JSONObject)bean).get(name);
        }
        if (bean instanceof JSONArray) {
            return ((JSONArray)bean).get(Integer.parseInt(name));
        }
        throw new UnsupportedOperationException("Can not get by name for: " + bean.getClass());
    }

    private Object getValueByRangeNode(JSON bean, RangeNode node) {
        if (bean instanceof JSONArray) {
            return CollUtil.sub((JSONArray)bean, node.getStart(), node.getEnd(), node.getStep());
        }
        throw new UnsupportedOperationException("Can not get range value for: " + bean.getClass());
    }
}

