/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.shape;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.file.FileTypeUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.stream.StreamUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.poi.excel.shape.ExcelPicType;

public class ExcelPicUtil {
    public static ExcelPicType getPicType(File picFile) {
        String type = FileTypeUtil.getType(picFile);
        if (StrUtil.equalsAnyIgnoreCase(type, "jpg", "jpeg")) {
            return ExcelPicType.JPEG;
        }
        if (StrUtil.equalsAnyIgnoreCase(type, "emf")) {
            return ExcelPicType.EMF;
        }
        if (StrUtil.equalsAnyIgnoreCase(type, "wmf")) {
            return ExcelPicType.WMF;
        }
        if (StrUtil.equalsAnyIgnoreCase(type, "pict")) {
            return ExcelPicType.PICT;
        }
        if (StrUtil.equalsAnyIgnoreCase(type, "dib")) {
            return ExcelPicType.DIB;
        }
        return ExcelPicType.PNG;
    }

    public static void writePicTo(Picture pic, File file) {
        ExcelPicUtil.writePicTo(pic.getPictureData(), file);
    }

    public static void writePicTo(PictureData pic, File file) {
        FileUtil.writeBytes(pic.getData(), file);
    }

    public static List<? extends PictureData> getAllPictures(Workbook workbook) {
        return workbook.getAllPictures();
    }

    public static List<Picture> getShapePics(Workbook workbook, int sheetIndex) {
        Assert.notNull(workbook, "Workbook must be not null !", new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        return ExcelPicUtil.getShapePics(workbook.getSheetAt(sheetIndex));
    }

    public static List<Picture> getShapePics(Sheet sheet) {
        Assert.notNull(sheet, "Sheet must be not null !", new Object[0]);
        Drawing drawing = sheet.getDrawingPatriarch();
        if (null == drawing) {
            return ListUtil.empty();
        }
        return StreamUtil.of(drawing).filter(shape -> shape instanceof Picture).map(shape -> (Picture)shape).collect(Collectors.toList());
    }
}

