/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net;

import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.net.Ipv4Util;
import org.dromara.hutool.core.net.MacAddressUtil;
import org.dromara.hutool.core.net.NetUtil;

public class Ipv6Util {
    private static volatile String localhostName;

    public static BigInteger ipv6ToBigInteger(String ipv6Str) {
        try {
            InetAddress address = InetAddress.getByName(ipv6Str);
            if (address instanceof Inet6Address) {
                return new BigInteger(1, address.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static String bigIntegerToIPv6(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16)) > 0) {
            throw new IllegalArgumentException("BigInteger value is out of IPv6 range");
        }
        byte[] bytes = bigInteger.toByteArray();
        if (bytes.length > 16) {
            int offset = bytes[0] == 0 ? 1 : 0;
            byte[] newBytes = new byte[16];
            System.arraycopy(bytes, offset, newBytes, 0, 16);
            bytes = newBytes;
        } else if (bytes.length < 16) {
            byte[] paddedBytes = new byte[16];
            System.arraycopy(bytes, 0, paddedBytes, 16 - bytes.length, bytes.length);
            bytes = paddedBytes;
        }
        try {
            return Inet6Address.getByAddress(bytes).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet6Address);
        return NetUtil.toIpList(localAddressList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalHostName() {
        if (null != localhostName) return localhostName;
        Class<Ipv4Util> clazz = Ipv4Util.class;
        synchronized (Ipv4Util.class) {
            if (null != localhostName) return localhostName;
            localhostName = NetUtil.getAddressName(Ipv6Util.getLocalhostDirectly());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhostName;
        }
    }

    public static String getLocalMacAddress() {
        return MacAddressUtil.getMacAddress(Ipv6Util.getLocalhost());
    }

    public static byte[] getLocalHardwareAddress() {
        return MacAddressUtil.getHardwareAddress(Ipv6Util.getLocalhost());
    }

    public static InetAddress getLocalhost() {
        return Singleton.get(Ipv6Util.class.getName(), Ipv6Util::getLocalhostDirectly);
    }

    public static InetAddress getLocalhostDirectly() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> address instanceof Inet6Address && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress());
        if (CollUtil.isNotEmpty(localAddressList)) {
            return CollUtil.getFirst(localAddressList);
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet6Address) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int index = addr.lastIndexOf(37);
        if (index > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, index) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                throw new HutoolException(e);
            }
        }
        return address;
    }
}

