/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.replacer;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.replacer.StrReplacer;

public class SearchReplacer
extends StrReplacer {
    private static final long serialVersionUID = 1L;
    private static final int INDEX_NOT_FOUND = -1;
    private final int fromIndex;
    private final CharSequence searchStr;
    private final int searchStrLength;
    private final CharSequence replacement;
    private final boolean ignoreCase;

    public SearchReplacer(int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        this.fromIndex = Math.max(fromIndex, 0);
        this.searchStr = Assert.notEmpty(searchStr, "'searchStr' must be not empty!", new Object[0]);
        this.searchStrLength = searchStr.length();
        this.replacement = StrUtil.toStringOrEmpty(replacement);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String apply(CharSequence str) {
        int consumed;
        if (StrUtil.isEmpty(str)) {
            return StrUtil.toStringOrNull(str);
        }
        int strLength = str.length();
        if (strLength < this.searchStrLength) {
            return StrUtil.toStringOrNull(str);
        }
        int fromIndex = this.fromIndex;
        if (fromIndex > strLength) {
            return "";
        }
        StringBuilder result = new StringBuilder(strLength - this.searchStrLength + this.replacement.length());
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int pos = fromIndex;
        while ((consumed = this.replace(str, pos, result)) > 0) {
            pos += consumed;
        }
        if (pos < strLength) {
            result.append(str.subSequence(pos, strLength));
        }
        return result.toString();
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        int index = StrUtil.indexOf(str, this.searchStr, pos, this.ignoreCase);
        if (index > -1) {
            out.append(str.subSequence(pos, index));
            out.append(this.replacement);
            return index - pos + this.searchStrLength;
        }
        return -1;
    }
}

