/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.net.Proxy;
import java.net.URL;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.engine.EngineRequestBuilder;
import org.dromara.hutool.http.client.engine.jdk.JdkCookieManager;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.proxy.ProxyInfo;

public class JdkRequestBuilder
implements EngineRequestBuilder<JdkHttpConnection> {
    private final ClientConfig config;
    private final JdkCookieManager cookieManager;

    public JdkRequestBuilder(ClientConfig config, JdkCookieManager cookieManager) {
        this.config = ObjUtil.defaultIfNull(config, ClientConfig::of);
        this.cookieManager = cookieManager;
    }

    @Override
    public JdkHttpConnection build(Request message) {
        ClientConfig config = this.config;
        URL url = message.handledUrl().toURL();
        Proxy proxy = null;
        ProxyInfo proxyInfo = config.getProxy();
        if (null != proxyInfo) {
            proxy = proxyInfo.selectFirst(UrlUtil.toURI(url));
        }
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(url, proxy).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSSLInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (!message.method().isIgnoreBody()) {
            long contentLength = message.contentLength();
            if (contentLength > 0L) {
                conn.setFixedLengthStreamingMode(contentLength);
            } else if (message.isChunked()) {
                conn.setChunkedStreamingMode(4096);
            }
        }
        if (null == message.header(HeaderName.COOKIE) && null != this.cookieManager) {
            conn.header(this.cookieManager.loadForRequest(conn), false);
        }
        return conn;
    }
}

