/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.writer.JSONWriter;

public interface JSON
extends Serializable {
    public JSONFactory getFactory();

    public int size();

    public void write(JSONWriter var1) throws JSONException;

    default public JSONConfig config() {
        return this.getFactory().getConfig();
    }

    default public boolean isEmpty() {
        return 0 == this.size();
    }

    default public JSONObject asJSONObject() {
        return (JSONObject)this;
    }

    default public JSONArray asJSONArray() {
        return (JSONArray)this;
    }

    default public JSONPrimitive asJSONPrimitive() {
        return (JSONPrimitive)this;
    }

    default public <T> T getObjByPath(String expression) {
        return this.getByPath(expression, (Type)((Object)Object.class));
    }

    default public <T> T getByPath(String expression, Type resultType) {
        JSON json = this.getByPath(expression);
        if (null == json) {
            return null;
        }
        return json.toBean(resultType);
    }

    default public JSON getByPath(String expression) {
        return (JSON)JSONFactory.of(this.config(), null).ofBeanPath(expression).getValue(this);
    }

    default public void putByPath(String expression, Object value) {
        JSONFactory.of(this.config(), null).ofBeanPath(expression).setValue(this, value);
    }

    default public String toStringPretty() throws JSONException {
        return this.toJSONString(2);
    }

    default public String toJSONString(int indentFactor) throws JSONException {
        JSONWriter jsonWriter = this.getFactory().ofWriter((Appendable)new StringBuilder(), indentFactor);
        this.write(jsonWriter);
        return jsonWriter.toString();
    }

    default public String toJSONString(int indentFactor, Predicate<MutableEntry<Object, Object>> predicate) throws JSONException {
        JSONWriter jsonWriter = JSONFactory.of(this.config(), predicate).ofWriter((Appendable)new StringBuilder(), indentFactor);
        this.write(jsonWriter);
        return jsonWriter.toString();
    }

    default public <T> T toBean(Type type) {
        return this.getFactory().toBean(this, type);
    }
}

