/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.qrcode.render;

import com.google.zxing.common.BitMatrix;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.ansi.AnsiElement;
import org.dromara.hutool.core.lang.ansi.AnsiEncoder;
import org.dromara.hutool.swing.img.color.ColorUtil;
import org.dromara.hutool.swing.qrcode.QrConfig;
import org.dromara.hutool.swing.qrcode.render.BitMatrixRender;

public class AsciiArtRender
implements BitMatrixRender {
    private final QrConfig config;

    public AsciiArtRender(QrConfig config) {
        this.config = config;
    }

    @Override
    public void render(BitMatrix matrix, OutputStream out) {
        this.render(matrix, new OutputStreamWriter(out, this.config.getCharset()));
    }

    public void render(BitMatrix matrix, Appendable writer) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        Integer foreColor = this.config.getForeColor();
        AnsiElement foreground = foreColor == null ? null : ColorUtil.toAnsiColor(foreColor, true, false);
        Integer backColor = this.config.getBackColor();
        AnsiElement background = backColor == null ? null : ColorUtil.toAnsiColor(backColor, true, true);
        try {
            for (int i = 0; i <= height; i += 2) {
                StringBuilder rowBuilder = new StringBuilder();
                for (int j = 0; j < width; ++j) {
                    boolean bt;
                    boolean tp = matrix.get(i, j);
                    boolean bl = bt = i + 1 >= height || matrix.get(i + 1, j);
                    if (tp && bt) {
                        rowBuilder.append(' ');
                        continue;
                    }
                    if (tp) {
                        rowBuilder.append('\u2584');
                        continue;
                    }
                    if (bt) {
                        rowBuilder.append('\u2580');
                        continue;
                    }
                    rowBuilder.append('\u2588');
                }
                writer.append(AnsiEncoder.encode(foreground, background, rowBuilder)).append('\n');
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

