/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.core;

import java.util.Map;
import java.util.ServiceLoader;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;

public class AIConfigRegistry {
    private static final Map<String, Class<? extends AIConfig>> configClasses = new SafeConcurrentHashMap<String, Class<? extends AIConfig>>();

    public static Class<? extends AIConfig> getConfigClass(String modelName) {
        return configClasses.get(modelName.toLowerCase());
    }

    static {
        ServiceLoader<AIConfig> loader = ServiceLoader.load(AIConfig.class);
        for (AIConfig config : loader) {
            configClasses.put(config.getModelName().toLowerCase(), config.getClass());
        }
    }
}

