/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data.id;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.dromara.hutool.core.data.id.IdConstants;
import org.dromara.hutool.core.lang.generator.Generator;
import org.dromara.hutool.core.text.StrUtil;

public class SeataSnowflake
implements Generator<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_TWEPOCH = 1588435200000L;
    private static final int NODE_ID_BITS = 10;
    protected static final int MAX_NODE_ID = 1023;
    private static final int TIMESTAMP_BITS = 41;
    private static final int SEQUENCE_BITS = 12;
    private static final long timestampAndSequenceMask = 0x1FFFFFFFFFFFFFL;
    private long nodeId;
    private final AtomicLong timestampAndSequence;

    public SeataSnowflake() {
        this(null);
    }

    public SeataSnowflake(Long nodeId) {
        this(null, nodeId);
    }

    public SeataSnowflake(Date epochDate, Long nodeId) {
        long twepoch = null == epochDate ? 1588435200000L : epochDate.getTime();
        long timestampWithSequence = System.currentTimeMillis() - twepoch << 12;
        this.timestampAndSequence = new AtomicLong(timestampWithSequence);
        this.initNodeId(nodeId);
    }

    @Override
    public Long next() {
        long next = this.timestampAndSequence.incrementAndGet();
        long timestampWithSequence = next & 0x1FFFFFFFFFFFFFL;
        return this.nodeId | timestampWithSequence;
    }

    public String nextStr() {
        return Long.toString(this.next());
    }

    private void initNodeId(Long nodeId) {
        if (nodeId == null) {
            nodeId = IdConstants.DEFAULT_SEATA_NODE_ID;
        }
        if (nodeId > 1023L || nodeId < 0L) {
            String message = StrUtil.format("worker Id can't be greater than {} or less than 0", 1023);
            throw new IllegalArgumentException(message);
        }
        this.nodeId = nodeId << 53;
    }
}

