/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date;

import java.util.Date;
import org.dromara.hutool.core.date.DateField;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.lang.range.Range;

public class DateRange
extends Range<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateRange(Date start, Date end, DateField unit) {
        this(start, end, unit, 1);
    }

    public DateRange(Date start, Date end, DateField unit, int step) {
        this(start, end, unit, step, true, true);
    }

    public DateRange(Date start, Date end, DateField unit, int step, boolean isIncludeStart, boolean isIncludeEnd) {
        super(DateUtil.date(start), DateUtil.date(end), (current, end1, index) -> {
            if (step <= 0) {
                return null;
            }
            DateTime dt = DateUtil.date(start).offsetNew(unit, (index + 1) * step);
            if (dt.isAfter((Date)end1)) {
                return null;
            }
            return dt;
        }, isIncludeStart, isIncludeEnd);
    }
}

