/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.util.Map;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import org.dromara.hutool.crypto.asymmetric.Sign;
import org.dromara.hutool.crypto.asymmetric.SignAlgorithm;
import org.dromara.hutool.crypto.digest.DigestAlgorithm;
import org.dromara.hutool.crypto.digest.Digester;
import org.dromara.hutool.crypto.provider.GlobalProviderFactory;
import org.dromara.hutool.crypto.symmetric.SymmetricCrypto;

public class SignUtil {
    public static Signature createSignature(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        return SignUtil.createSignature(SecureUtil.generateAlgorithm(asymmetricAlgorithm, digestAlgorithm));
    }

    public static Signature createSignature(String algorithm) {
        Signature signature;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            signature = null == provider ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return signature;
    }

    public static Sign sign(SignAlgorithm algorithm) {
        return new Sign(algorithm);
    }

    public static Sign sign(SignAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        return new Sign(algorithm, privateKeyBase64, publicKeyBase64);
    }

    public static Sign sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static String signParams(SymmetricCrypto crypto, Map<?, ?> params, String ... otherParams) {
        return SignUtil.signParams(crypto, params, "", "", true, otherParams);
    }

    public static String signParams(SymmetricCrypto crypto, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return crypto.encryptHex(MapUtil.sortJoin(params, separator, keyValueSeparator, isIgnoreNull, otherParams));
    }

    public static String signParamsMd5(Map<?, ?> params, String ... otherParams) {
        return SignUtil.signParams(DigestAlgorithm.MD5, params, otherParams);
    }

    public static String signParamsSha1(Map<?, ?> params, String ... otherParams) {
        return SignUtil.signParams(DigestAlgorithm.SHA1, params, otherParams);
    }

    public static String signParamsSha256(Map<?, ?> params, String ... otherParams) {
        return SignUtil.signParams(DigestAlgorithm.SHA256, params, otherParams);
    }

    public static String signParams(DigestAlgorithm digestAlgorithm, Map<?, ?> params, String ... otherParams) {
        return SignUtil.signParams(digestAlgorithm, params, "", "", true, otherParams);
    }

    public static String signParams(DigestAlgorithm digestAlgorithm, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return new Digester(digestAlgorithm).digestHex(MapUtil.sortJoin(params, separator, keyValueSeparator, isIgnoreNull, otherParams));
    }
}

