/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.config.ConfigParser;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.config.SettingConfigParser;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSUtil;
import org.dromara.hutool.db.ds.DSWrapper;
import org.dromara.hutool.log.LogUtil;

public class DSPool
implements Closeable {
    private final ConfigParser configParser;
    private final Map<String, DSWrapper> pool;
    private DSFactory factory;

    public static DSPool getInstance() {
        return Singleton.get(DSPool.class.getName(), DSPool::new);
    }

    public DSPool() {
        this(null);
    }

    public DSPool(ConfigParser configParser) {
        this(configParser, null);
    }

    public DSPool(ConfigParser configParser, DSFactory factory) {
        this.configParser = null != configParser ? configParser : SettingConfigParser.of();
        this.factory = null != factory ? factory : DSUtil.getDefaultDsFactory();
        this.pool = new SafeConcurrentHashMap<String, DSWrapper>();
    }

    public ConfigParser getConfigParser() {
        return this.configParser;
    }

    public String getDataSourceName() {
        return this.factory.getDataSourceName();
    }

    public DSFactory getFactory() {
        return this.factory;
    }

    public DSPool setFactory(DSFactory factory) {
        this.factory = factory;
        LogUtil.debug("Custom use [{}] DataSource.", factory.getDataSourceName());
        return this;
    }

    public DSWrapper getDataSource(String group) {
        if (group == null) {
            group = "";
        }
        return this.pool.computeIfAbsent(group, this::createDSWrapper);
    }

    public DSPool closeDataSource(String group) {
        DSWrapper removed;
        if (group == null) {
            group = "";
        }
        if (null != (removed = this.pool.remove(group))) {
            IoUtil.closeQuietly(removed);
        }
        return this;
    }

    @Override
    public void close() {
        Map<String, DSWrapper> pool = this.pool;
        if (MapUtil.isNotEmpty(pool)) {
            Collection<DSWrapper> values = pool.values();
            pool.clear();
            for (DSWrapper ds : values) {
                ds.close();
            }
        }
    }

    private DSWrapper createDSWrapper(String group) {
        DbConfig dbConfig = this.configParser.parse(StrUtil.toStringOrEmpty(group));
        return DSWrapper.wrap(this.factory.createDataSource(dbConfig), dbConfig);
    }
}

