/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.extra.mq.Consumer;
import org.dromara.hutool.extra.mq.MQConfig;
import org.dromara.hutool.extra.mq.MQException;
import org.dromara.hutool.extra.mq.Producer;
import org.dromara.hutool.extra.mq.engine.MQEngine;
import org.dromara.hutool.extra.mq.engine.rabbitmq.RabbitMQConsumer;
import org.dromara.hutool.extra.mq.engine.rabbitmq.RabbitMQProducer;

public class RabbitMQEngine
implements MQEngine,
Closeable {
    private Connection connection;

    public RabbitMQEngine() {
        Assert.notNull(Connection.class);
    }

    public RabbitMQEngine(MQConfig config) {
        this.init(config);
    }

    public RabbitMQEngine(ConnectionFactory factory) {
        this.init(factory);
    }

    @Override
    public RabbitMQEngine init(MQConfig config) {
        return this.init(RabbitMQEngine.createFactory(config));
    }

    public RabbitMQEngine init(ConnectionFactory factory) {
        try {
            this.connection = factory.newConnection();
        }
        catch (IOException | TimeoutException e) {
            throw new MQException(e);
        }
        return this;
    }

    @Override
    public Producer getProducer() {
        return new RabbitMQProducer(this.createChannel());
    }

    @Override
    public Consumer getConsumer() {
        return new RabbitMQConsumer(this.createChannel());
    }

    @Override
    public void close() throws IOException {
        IoUtil.nullSafeClose((Closeable)this.connection);
    }

    private Channel createChannel() {
        try {
            return this.connection.createChannel();
        }
        catch (IOException e) {
            throw new MQException(e);
        }
    }

    private static ConnectionFactory createFactory(MQConfig config) {
        ConnectionFactory factory = new ConnectionFactory();
        try {
            factory.setUri(config.getBrokerUrl());
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        return factory;
    }
}

