/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.text.StrUtil;

public interface HttpBody {
    public void write(OutputStream var1);

    public String contentType();

    default public long contentLength() {
        return -1L;
    }

    default public String contentType(Charset charset) {
        String contentType = this.contentType();
        if (null == contentType) {
            return null;
        }
        String charsetName = charset.name();
        if (StrUtil.endWithIgnoreCase(contentType, charsetName) || StrUtil.containsIgnoreCase(contentType, "boundary=")) {
            return contentType;
        }
        if (StrUtil.containsIgnoreCase(contentType, ";charset=")) {
            contentType = StrUtil.subBefore((CharSequence)contentType, ";charset=", true);
        }
        return contentType + ";charset=" + charset.name();
    }

    default public void writeClose(OutputStream out) {
        try {
            this.write(out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(out);
            throw throwable;
        }
        IoUtil.closeQuietly(out);
    }

    default public InputStream getStream() {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.writeClose(out);
        return IoUtil.toStream(out);
    }

    default public byte[] getBytes() {
        InputStream bodyStream = this.getStream();
        if (bodyStream == null) {
            return null;
        }
        return IoUtil.readBytes(bodyStream);
    }
}

