/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.httpclient5;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.ResponseBody;

public class HttpClient5Response
extends SimpleWrapper<ClassicHttpResponse>
implements Response {
    private final HttpEntity entity;
    private final Charset requestCharset;
    private final ResponseBody body;

    public HttpClient5Response(ClassicHttpResponse rawRes, Request message) {
        super(rawRes);
        this.entity = rawRes.getEntity();
        this.requestCharset = message.charset();
        this.body = message.method().isIgnoreBody() ? null : new ResponseBody(this, this.bodyStream());
    }

    @Override
    public int getStatus() {
        return ((ClassicHttpResponse)this.raw).getCode();
    }

    @Override
    public String header(String name) {
        Header[] headers = ((ClassicHttpResponse)this.raw).getHeaders(name);
        if (ArrayUtil.isNotEmpty(headers)) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> headers() {
        Header[] headers = ((ClassicHttpResponse)this.raw).getHeaders();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(headers.length, 1.0f);
        for (Header header : headers) {
            List valueList = result.computeIfAbsent(header.getName(), k -> new ArrayList());
            valueList.add(header.getValue());
        }
        return result;
    }

    @Override
    public long contentLength() {
        return this.entity.getContentLength();
    }

    @Override
    public Charset charset() {
        return ObjUtil.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        try {
            return this.entity.getContent();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public HttpClient5Response sync() {
        ResponseBody body = this.body;
        if (null != body) {
            body.sync();
        }
        IoUtil.closeQuietly((AutoCloseable)this.raw);
        return this;
    }

    @Override
    public ResponseBody body() {
        return this.body;
    }

    @Override
    public String bodyStr() throws HttpException {
        try {
            return EntityUtils.toString((HttpEntity)this.entity, (Charset)this.charset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ParseException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void close() throws IOException {
        ((ClassicHttpResponse)this.raw).close();
    }

    public String toString() {
        return HttpUtil.toString(this);
    }
}

