/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.HeaderOperation;
import org.dromara.hutool.http.client.engine.jdk.HttpUrlConnectionUtil;
import org.dromara.hutool.http.meta.Method;
import org.dromara.hutool.http.ssl.SSLInfo;

public class JdkHttpConnection
implements HeaderOperation<JdkHttpConnection>,
Closeable {
    private final URL url;
    private final Proxy proxy;
    private final HttpURLConnection conn;

    public static JdkHttpConnection of(String urlStr, Proxy proxy) {
        return JdkHttpConnection.of(UrlUtil.toUrlForHttp(urlStr), proxy);
    }

    public static JdkHttpConnection of(URL url, Proxy proxy) {
        return new JdkHttpConnection(url, proxy);
    }

    public JdkHttpConnection(URL url, Proxy proxy) {
        this.url = url;
        this.proxy = proxy;
        this.conn = HttpUrlConnectionUtil.openHttp(url, proxy);
        this.conn.setDoInput(true);
    }

    public Method getMethod() {
        return Method.valueOf(this.conn.getRequestMethod());
    }

    public JdkHttpConnection setMethod(Method method) {
        if (Method.POST.equals((Object)method) || Method.PUT.equals((Object)method) || Method.PATCH.equals((Object)method) || Method.DELETE.equals((Object)method)) {
            this.conn.setUseCaches(false);
            if (Method.PATCH.equals((Object)method)) {
                HttpUrlConnectionUtil.allowPatch();
            }
        }
        try {
            this.conn.setRequestMethod(method.toString());
        }
        catch (ProtocolException e) {
            throw new HttpException(e);
        }
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HttpURLConnection getHttpURLConnection() {
        return this.conn;
    }

    public JdkHttpConnection setDisableCache(boolean isDisableCache) {
        this.conn.setUseCaches(!isDisableCache);
        return this;
    }

    public JdkHttpConnection setConnectTimeout(int timeout) {
        if (timeout > 0 && null != this.conn) {
            this.conn.setConnectTimeout(timeout);
        }
        return this;
    }

    public JdkHttpConnection setReadTimeout(int timeout) {
        if (timeout > 0 && null != this.conn) {
            this.conn.setReadTimeout(timeout);
        }
        return this;
    }

    public JdkHttpConnection setConnectionAndReadTimeout(int timeout) {
        this.setConnectTimeout(timeout);
        this.setReadTimeout(timeout);
        return this;
    }

    public JdkHttpConnection setSSLInfo(SSLInfo sslInfo) throws HttpException {
        HttpURLConnection conn = this.conn;
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            Opt.ofNullable(sslInfo.getHostnameVerifier()).ifPresent(httpsConn::setHostnameVerifier);
            Opt.ofNullable(sslInfo.getSocketFactory()).ifPresent(httpsConn::setSSLSocketFactory);
        }
        return this;
    }

    public JdkHttpConnection setFixedLengthStreamingMode(long contentLength) {
        if (contentLength > 0L) {
            this.conn.setFixedLengthStreamingMode(contentLength);
        }
        return this;
    }

    public JdkHttpConnection setChunkedStreamingMode(int blockSize) {
        if (blockSize > 0) {
            this.conn.setChunkedStreamingMode(blockSize);
        }
        return this;
    }

    public JdkHttpConnection setInstanceFollowRedirects(boolean isInstanceFollowRedirects) {
        this.conn.setInstanceFollowRedirects(isInstanceFollowRedirects);
        return this;
    }

    @Override
    public JdkHttpConnection header(String header, String value, boolean isOverride) {
        if (null != this.conn) {
            if (isOverride) {
                this.conn.setRequestProperty(header, value);
            } else {
                this.conn.addRequestProperty(header, value);
            }
        }
        return this;
    }

    @Override
    public String header(String name) {
        return this.conn.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.conn.getHeaderFields();
    }

    public JdkHttpConnection connect() throws IOException {
        if (null != this.conn) {
            this.conn.connect();
        }
        return this;
    }

    public InputStream getInputStream() throws IOException {
        if (null != this.conn) {
            return this.conn.getInputStream();
        }
        return null;
    }

    public InputStream getErrorStream() {
        if (null != this.conn) {
            return this.conn.getErrorStream();
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (null == this.conn) {
            throw new IOException("HttpURLConnection has not been initialized.");
        }
        Method method = this.getMethod();
        this.conn.setDoOutput(true);
        OutputStream out = this.conn.getOutputStream();
        if (method == Method.GET && method != this.getMethod()) {
            try {
                FieldUtil.setFieldValue((Object)this.conn, "method", (Object)Method.GET.name());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return out;
    }

    public int getCode() throws IOException {
        if (null != this.conn) {
            return this.conn.getResponseCode();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Request URL: ").append(this.url).append("\r\n");
        sb.append("Request Method: ").append((Object)this.getMethod()).append("\r\n");
        return sb.toString();
    }

    public JdkHttpConnection closeQuietly() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }
}

