/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server;

import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.dromara.hutool.core.net.ssl.SSLContextUtil;

public class ServerConfig {
    private String host = "localhost";
    private int port = 8888;
    private String root;
    private SSLContext sslContext;
    private int maxHeaderSize;
    private long maxBodySize;
    private int coreThreads;
    private int maxThreads;
    private long idleTimeout;

    public static ServerConfig of() {
        return new ServerConfig();
    }

    public String getHost() {
        return this.host;
    }

    public ServerConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ServerConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public String getRoot() {
        return this.root;
    }

    public ServerConfig setRoot(String root) {
        this.root = root;
        return this;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ServerConfig setKeystore(KeyStore keyStore, char[] passwd) {
        return this.setSslContext(SSLContextUtil.createSSLContext(keyStore, passwd));
    }

    public ServerConfig setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public ServerConfig setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public long getMaxBodySize() {
        return this.maxBodySize;
    }

    public ServerConfig setMaxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
        return this;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public ServerConfig setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public ServerConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public ServerConfig setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }
}

