/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.sun;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.SSLContext;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.thread.ExecutorBuilder;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.AbstractServerEngine;
import org.dromara.hutool.http.server.engine.sun.HttpExchangeWrapper;
import org.dromara.hutool.http.server.engine.sun.SunServerRequest;
import org.dromara.hutool.http.server.engine.sun.SunServerResponse;
import org.dromara.hutool.http.server.engine.sun.filter.HttpFilter;
import org.dromara.hutool.http.server.engine.sun.filter.SimpleFilter;

public class SunHttpServerEngine
extends AbstractServerEngine {
    private HttpServer server;
    private List<Filter> filters;

    @Override
    public void start() {
        this.initEngine();
        this.server.start();
    }

    @Override
    public HttpServer getRawEngine() {
        return this.server;
    }

    public SunHttpServerEngine addFilter(Filter filter) {
        if (null == this.filters) {
            this.filters = new ArrayList<Filter>();
        }
        this.filters.add(filter);
        return this;
    }

    public SunHttpServerEngine addFilter(final HttpFilter filter) {
        return this.addFilter(new SimpleFilter(){

            @Override
            public void doFilter(HttpExchange httpExchange, Filter.Chain chain) throws IOException {
                HttpExchangeWrapper httpExchangeWrapper = new HttpExchangeWrapper(httpExchange);
                filter.doFilter(httpExchangeWrapper.getRequest(), httpExchangeWrapper.getResponse(), chain);
            }
        });
    }

    public HttpContext createContext(String path, HttpHandler handler) {
        path = StrUtil.addPrefixIfNot(path, "/");
        HttpContext context = this.server.createContext(path, handler);
        if (CollUtil.isNotEmpty(this.filters)) {
            context.getFilters().addAll(this.filters);
        }
        return context;
    }

    public SunHttpServerEngine setExecutor(Executor executor) {
        this.server.setExecutor(executor);
        return this;
    }

    @Override
    protected void reset() {
        if (null != this.server) {
            this.server.stop(0);
            this.server = null;
        }
        this.server = SunHttpServerEngine.createServer(this.config);
    }

    @Override
    protected void initEngine() {
        this.createContext("/", exchange -> this.handler.handle(new SunServerRequest(exchange), new SunServerResponse(exchange)));
    }

    private static HttpServer createServer(ServerConfig config) {
        HttpServer server;
        InetSocketAddress address = new InetSocketAddress(config.getHost(), config.getPort());
        SSLContext sslContext = config.getSslContext();
        try {
            if (null != sslContext) {
                HttpsServer httpsServer = HttpsServer.create(address, 0);
                httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext));
                server = httpsServer;
            } else {
                server = HttpServer.create(address, 0);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        server.setExecutor(SunHttpServerEngine.createExecutor(config));
        return server;
    }

    private static ThreadPoolExecutor createExecutor(ServerConfig config) {
        long idleTimeout;
        int maxThreads;
        ExecutorBuilder executorBuilder = ExecutorBuilder.of();
        int coreThreads = config.getCoreThreads();
        if (coreThreads > 0) {
            executorBuilder.setCorePoolSize(coreThreads);
        }
        if ((maxThreads = config.getMaxThreads()) > 0) {
            executorBuilder.setMaxPoolSize(maxThreads);
        }
        if ((idleTimeout = config.getIdleTimeout()) > 0L) {
            executorBuilder.setKeepAliveTime(idleTimeout);
        }
        return executorBuilder.build();
    }
}

