/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt.signers;

import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.asymmetric.Sign;
import org.dromara.hutool.json.jwt.signers.JWTSigner;

public class AsymmetricJWTSigner
implements JWTSigner {
    private Charset charset = CharsetUtil.UTF_8;
    private final Sign sign;

    public AsymmetricJWTSigner(String algorithm, Key key) {
        PublicKey publicKey = key instanceof PublicKey ? (PublicKey)key : null;
        PrivateKey privateKey = key instanceof PrivateKey ? (PrivateKey)key : null;
        this.sign = new Sign(algorithm, new KeyPair(publicKey, privateKey));
    }

    public AsymmetricJWTSigner(String algorithm, KeyPair keyPair) {
        this.sign = new Sign(algorithm, keyPair);
    }

    public AsymmetricJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        String dataStr = StrUtil.format("{}.{}", headerBase64, payloadBase64);
        return Base64.encodeUrlSafe(this.sign(ByteUtil.toBytes(dataStr, this.charset)));
    }

    protected byte[] sign(byte[] data) {
        return this.sign.sign(data);
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        return this.verify(ByteUtil.toBytes(StrUtil.format("{}.{}", headerBase64, payloadBase64), this.charset), Base64.decode(signBase64));
    }

    protected boolean verify(byte[] data, byte[] signed) {
        return this.sign.verify(data, signed);
    }

    @Override
    public String getAlgorithm() {
        return this.sign.getSignature().getAlgorithm();
    }
}

