/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class ThrowableTypeAdapter
implements MatcherJSONSerializer<Throwable>,
MatcherJSONDeserializer<Throwable> {
    public static final ThrowableTypeAdapter INSTANCE = new ThrowableTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof Throwable;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return Throwable.class.isAssignableFrom(TypeUtil.getClass(deserializeType));
    }

    @Override
    public JSON serialize(Throwable bean, JSONContext context) {
        return new JSONPrimitive((Object)StrUtil.format("{}: {}", bean.getClass().getName(), bean.getMessage()), ObjUtil.apply(context, JSONContext::config));
    }

    @Override
    public Throwable deserialize(JSON json, Type deserializeType) {
        String value = (String)json.asJSONPrimitive().getValue();
        return (Throwable)ConstructorUtil.newInstance(TypeUtil.getClass(deserializeType), StrUtil.subAfter((CharSequence)value, ": ", false));
    }
}

