/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel;

import org.apache.poi.ss.usermodel.IgnoredErrorType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.cellwalk.CellHandler;
import org.apache.poi.ss.util.cellwalk.CellWalk;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.dromara.hutool.core.reflect.FieldUtil;

public class SheetUtil {
    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        Sheet sheet;
        if (null == book) {
            return null;
        }
        if (null == sheetName) {
            sheet = SheetUtil.getOrCreateSheet(book, 0);
        } else {
            sheet = book.getSheet(sheetName);
            if (null == sheet) {
                sheet = book.createSheet(sheetName);
            }
        }
        return sheet;
    }

    public static Sheet getOrCreateSheet(Workbook book, int sheetIndex) {
        Sheet sheet = null;
        try {
            sheet = book.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (null == sheet) {
            sheet = book.createSheet();
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }

    public static void walk(Sheet sheet, CellHandler cellHandler) {
        SheetUtil.walk(sheet, new CellRangeAddress(0, sheet.getLastRowNum(), 0, sheet.getLastRowNum()), cellHandler);
    }

    public static void walk(Sheet sheet, CellRangeAddress range, CellHandler cellHandler) {
        CellWalk cellWalk = new CellWalk(sheet, range);
        cellWalk.traverse(cellHandler);
    }

    public static void addIgnoredErrors(Sheet sheet, CellRangeAddress cellRangeAddress, IgnoredErrorType ... ignoredErrorTypes) throws UnsupportedOperationException {
        if (sheet instanceof XSSFSheet) {
            ((XSSFSheet)sheet).addIgnoredErrors(cellRangeAddress, ignoredErrorTypes);
        } else if (sheet instanceof SXSSFSheet) {
            XSSFSheet xssfSheet = (XSSFSheet)FieldUtil.getFieldValue((Object)sheet, "_sh");
            if (null != xssfSheet) {
                xssfSheet.addIgnoredErrors(cellRangeAddress, ignoredErrorTypes);
            }
        } else {
            throw new UnsupportedOperationException("Only XSSFSheet supports addIgnoredErrors");
        }
    }

    public static CellRangeAddress getMergedRegion(Sheet sheet, int x, int y) {
        for (CellRangeAddress ca : sheet.getMergedRegions()) {
            if (!ca.isInRange(y, x)) continue;
            return ca;
        }
        return null;
    }
}

