/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data.masking;

import java.util.HashSet;
import java.util.Set;

public class RichTextMaskingRule {
    private String name;
    private String pattern;
    private MaskType maskType;
    private String replacement;
    private int preserveLeft;
    private int preserveRight;
    private char maskChar = (char)42;
    private boolean processHtmlTags = false;
    private Set<String> excludeTags = new HashSet<String>();
    private Set<String> includeTags = new HashSet<String>();

    public RichTextMaskingRule() {
    }

    public RichTextMaskingRule(String name, String pattern, MaskType maskType, String replacement) {
        this.name = name;
        this.pattern = pattern;
        this.maskType = maskType;
        this.replacement = replacement;
    }

    public RichTextMaskingRule(String name, String pattern, int preserveLeft, int preserveRight, char maskChar) {
        this.name = name;
        this.pattern = pattern;
        this.maskType = MaskType.PARTIAL;
        this.preserveLeft = preserveLeft;
        this.preserveRight = preserveRight;
        this.maskChar = maskChar;
    }

    public String getName() {
        return this.name;
    }

    public RichTextMaskingRule setName(String name) {
        this.name = name;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public RichTextMaskingRule setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    public RichTextMaskingRule setMaskType(MaskType maskType) {
        this.maskType = maskType;
        return this;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public RichTextMaskingRule setReplacement(String replacement) {
        this.replacement = replacement;
        return this;
    }

    public int getPreserveLeft() {
        return this.preserveLeft;
    }

    public RichTextMaskingRule setPreserveLeft(int preserveLeft) {
        this.preserveLeft = preserveLeft;
        return this;
    }

    public int getPreserveRight() {
        return this.preserveRight;
    }

    public RichTextMaskingRule setPreserveRight(int preserveRight) {
        this.preserveRight = preserveRight;
        return this;
    }

    public char getMaskChar() {
        return this.maskChar;
    }

    public RichTextMaskingRule setMaskChar(char maskChar) {
        this.maskChar = maskChar;
        return this;
    }

    public boolean isProcessHtmlTags() {
        return this.processHtmlTags;
    }

    public RichTextMaskingRule setProcessHtmlTags(boolean processHtmlTags) {
        this.processHtmlTags = processHtmlTags;
        return this;
    }

    public Set<String> getExcludeTags() {
        return this.excludeTags;
    }

    public RichTextMaskingRule setExcludeTags(Set<String> excludeTags) {
        this.excludeTags = excludeTags;
        return this;
    }

    public RichTextMaskingRule addExcludeTag(String tag) {
        this.excludeTags.add(tag.toLowerCase());
        return this;
    }

    public Set<String> getIncludeTags() {
        return this.includeTags;
    }

    public RichTextMaskingRule setIncludeTags(Set<String> includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    public RichTextMaskingRule addIncludeTag(String tag) {
        this.includeTags.add(tag.toLowerCase());
        return this;
    }

    public static enum MaskType {
        FULL,
        PARTIAL,
        REPLACE;

    }
}

